/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.os.RemoteException;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzawo;
import com.google.android.gms.internal.ads.zzwk;
import com.google.android.gms.internal.ads.zzxz;
import javax.annotation.concurrent.GuardedBy;

public final class VideoController {
    @KeepForSdk
    public static final int PLAYBACK_STATE_UNKNOWN = 0;
    @KeepForSdk
    public static final int PLAYBACK_STATE_PLAYING = 1;
    @KeepForSdk
    public static final int PLAYBACK_STATE_PAUSED = 2;
    @KeepForSdk
    public static final int PLAYBACK_STATE_ENDED = 3;
    @KeepForSdk
    public static final int PLAYBACK_STATE_READY = 5;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    @Nullable
    private zzwk zzabn;
    @GuardedBy(value="lock")
    @Nullable
    private VideoLifecycleCallbacks zzabo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzwk zzwk2) {
        Object object = this.lock;
        synchronized (object) {
            this.zzabn = zzwk2;
            if (this.zzabo != null) {
                this.setVideoLifecycleCallbacks(this.zzabo);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final zzwk zzdd() {
        Object object = this.lock;
        synchronized (object) {
            return this.zzabn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void play() {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzabn == null) {
                return;
            }
            try {
                this.zzabn.play();
            }
            catch (RemoteException remoteException) {
                zzawo.zzc("Unable to call play on video controller.", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pause() {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzabn == null) {
                return;
            }
            try {
                this.zzabn.pause();
            }
            catch (RemoteException remoteException) {
                zzawo.zzc("Unable to call pause on video controller.", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void mute(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzabn == null) {
                return;
            }
            try {
                this.zzabn.mute(bl);
            }
            catch (RemoteException remoteException) {
                zzawo.zzc("Unable to call mute on video controller.", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isMuted() {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzabn == null) {
                return true;
            }
            try {
                return this.zzabn.isMuted();
            }
            catch (RemoteException remoteException) {
                zzawo.zzc("Unable to call isMuted on video controller.", remoteException);
                return true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final int getPlaybackState() {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzabn == null) {
                return 0;
            }
            try {
                return this.zzabn.getPlaybackState();
            }
            catch (RemoteException remoteException) {
                zzawo.zzc("Unable to call getPlaybackState on video controller.", remoteException);
                return 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isCustomControlsEnabled() {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzabn == null) {
                return false;
            }
            try {
                return this.zzabn.isCustomControlsEnabled();
            }
            catch (RemoteException remoteException) {
                zzawo.zzc("Unable to call isUsingCustomPlayerControls.", remoteException);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isClickToExpandEnabled() {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzabn == null) {
                return false;
            }
            try {
                return this.zzabn.isClickToExpandEnabled();
            }
            catch (RemoteException remoteException) {
                zzawo.zzc("Unable to call isClickToExpandEnabled.", remoteException);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setVideoLifecycleCallbacks(VideoLifecycleCallbacks videoLifecycleCallbacks) {
        Preconditions.checkNotNull((Object)videoLifecycleCallbacks, (Object)"VideoLifecycleCallbacks may not be null.");
        Object object = this.lock;
        synchronized (object) {
            this.zzabo = videoLifecycleCallbacks;
            if (this.zzabn == null) {
                return;
            }
            try {
                this.zzabn.zza(new zzxz(videoLifecycleCallbacks));
            }
            catch (RemoteException remoteException) {
                zzawo.zzc("Unable to call setVideoLifecycleCallbacks on video controller.", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final VideoLifecycleCallbacks getVideoLifecycleCallbacks() {
        Object object = this.lock;
        synchronized (object) {
            return this.zzabo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasVideoContent() {
        Object object = this.lock;
        synchronized (object) {
            return this.zzabn != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final float getAspectRatio() {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzabn == null) {
                return 0.0f;
            }
            try {
                return this.zzabn.getAspectRatio();
            }
            catch (RemoteException remoteException) {
                zzawo.zzc("Unable to call getAspectRatio on video controller.", remoteException);
                return 0.0f;
            }
        }
    }

    public static abstract class VideoLifecycleCallbacks {
        public void onVideoStart() {
        }

        public void onVideoPlay() {
        }

        public void onVideoPause() {
        }

        public void onVideoEnd() {
        }

        public void onVideoMute(boolean bl) {
        }
    }
}

