/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.doubleclick;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.ads.doubleclick.zza;
import com.google.android.gms.ads.mediation.MediationExtrasReceiver;
import com.google.android.gms.ads.mediation.NetworkExtras;
import com.google.android.gms.ads.mediation.customevent.CustomEvent;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzwr;
import com.google.android.gms.internal.ads.zzws;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Date;
import java.util.List;
import java.util.Set;

@VisibleForTesting
public final class PublisherAdRequest {
    public static final int ERROR_CODE_INTERNAL_ERROR = 0;
    public static final int ERROR_CODE_INVALID_REQUEST = 1;
    public static final int ERROR_CODE_NETWORK_ERROR = 2;
    public static final int ERROR_CODE_NO_FILL = 3;
    public static final int GENDER_UNKNOWN = 0;
    public static final int GENDER_MALE = 1;
    public static final int GENDER_FEMALE = 2;
    @Deprecated
    public static final int TAG_FOR_UNDER_AGE_OF_CONSENT_TRUE = 1;
    @Deprecated
    public static final int TAG_FOR_UNDER_AGE_OF_CONSENT_FALSE = 0;
    @Deprecated
    public static final int TAG_FOR_UNDER_AGE_OF_CONSENT_UNSPECIFIED = -1;
    @Deprecated
    public static final String MAX_AD_CONTENT_RATING_G = "G";
    @Deprecated
    public static final String MAX_AD_CONTENT_RATING_PG = "PG";
    @Deprecated
    public static final String MAX_AD_CONTENT_RATING_T = "T";
    @Deprecated
    public static final String MAX_AD_CONTENT_RATING_MA = "MA";
    public static final String DEVICE_ID_EMULATOR = "B3EEABB8EE11C2BE770B684D95219ECB";
    private final zzws zzaaz;

    private PublisherAdRequest(Builder builder) {
        this.zzaaz = new zzws(builder.zzabb);
    }

    @Deprecated
    public final Date getBirthday() {
        return this.zzaaz.getBirthday();
    }

    public final String getContentUrl() {
        return this.zzaaz.getContentUrl();
    }

    @Deprecated
    public final int getGender() {
        return this.zzaaz.getGender();
    }

    public final Set<String> getKeywords() {
        return this.zzaaz.getKeywords();
    }

    public final Location getLocation() {
        return this.zzaaz.getLocation();
    }

    public final boolean getManualImpressionsEnabled() {
        return this.zzaaz.getManualImpressionsEnabled();
    }

    @Deprecated
    public final <T extends NetworkExtras> T getNetworkExtras(Class<T> clazz) {
        return this.zzaaz.getNetworkExtras(clazz);
    }

    public final <T extends MediationExtrasReceiver> Bundle getNetworkExtrasBundle(Class<T> clazz) {
        return this.zzaaz.getNetworkExtrasBundle(clazz);
    }

    public final <T extends CustomEvent> Bundle getCustomEventExtrasBundle(Class<T> clazz) {
        return this.zzaaz.getCustomEventExtrasBundle(clazz);
    }

    public final String getPublisherProvidedId() {
        return this.zzaaz.getPublisherProvidedId();
    }

    public final boolean isTestDevice(Context context) {
        return this.zzaaz.isTestDevice(context);
    }

    public final Bundle getCustomTargeting() {
        return this.zzaaz.getCustomTargeting();
    }

    @Deprecated
    @KeepForSdk
    public static void updateCorrelator() {
    }

    public final zzws zzda() {
        return this.zzaaz;
    }

    /* synthetic */ PublisherAdRequest(Builder builder, zza zza2) {
        this(builder);
    }

    @Deprecated
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MaxAdContentRating {
    }

    @Deprecated
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TagForUnderAgeOfConsent {
    }

    @VisibleForTesting
    public static final class Builder {
        private final zzwr zzabb = new zzwr();

        public final Builder addKeyword(String string) {
            this.zzabb.zzca(string);
            return this;
        }

        public final Builder addNetworkExtras(NetworkExtras networkExtras) {
            this.zzabb.zza(networkExtras);
            return this;
        }

        public final Builder addNetworkExtrasBundle(Class<? extends MediationExtrasReceiver> clazz, Bundle bundle) {
            this.zzabb.zza(clazz, bundle);
            return this;
        }

        public final Builder addCustomEventExtrasBundle(Class<? extends CustomEvent> clazz, Bundle bundle) {
            this.zzabb.zzb(clazz, bundle);
            return this;
        }

        public final Builder addTestDevice(String string) {
            this.zzabb.zzcb(string);
            return this;
        }

        public final PublisherAdRequest build() {
            return new PublisherAdRequest(this, null);
        }

        @Deprecated
        public final Builder setBirthday(Date date) {
            this.zzabb.zza(date);
            return this;
        }

        public final Builder setContentUrl(String string) {
            Preconditions.checkNotNull((Object)string, (Object)"Content URL must be non-null.");
            Preconditions.checkNotEmpty((String)string, (Object)"Content URL must be non-empty.");
            Preconditions.checkArgument((string.length() <= 512 ? 1 : 0) != 0, (String)"Content URL must not exceed %d in length.  Provided length was %d.", (Object[])new Object[]{512, string.length()});
            this.zzabb.zzcd(string);
            return this;
        }

        @Deprecated
        public final Builder setGender(int n) {
            this.zzabb.zzch(n);
            return this;
        }

        public final Builder setLocation(Location location) {
            this.zzabb.zza(location);
            return this;
        }

        @Deprecated
        public final Builder setManualImpressionsEnabled(boolean bl) {
            this.zzabb.setManualImpressionsEnabled(bl);
            return this;
        }

        public final Builder setPublisherProvidedId(String string) {
            this.zzabb.zzce(string);
            return this;
        }

        public final Builder setRequestAgent(String string) {
            this.zzabb.zzcf(string);
            return this;
        }

        @Deprecated
        public final Builder tagForChildDirectedTreatment(boolean bl) {
            this.zzabb.zzs(bl);
            return this;
        }

        public final Builder addCustomTargeting(String string, String string2) {
            this.zzabb.zzg(string, string2);
            return this;
        }

        public final Builder addCustomTargeting(String string, List<String> list) {
            if (list != null) {
                this.zzabb.zzg(string, TextUtils.join((CharSequence)",", list));
            }
            return this;
        }

        public final Builder addCategoryExclusion(String string) {
            this.zzabb.zzcg(string);
            return this;
        }

        @Deprecated
        public final Builder setIsDesignedForFamilies(boolean bl) {
            this.zzabb.zzt(bl);
            return this;
        }

        @Deprecated
        public final Builder setTagForUnderAgeOfConsent(int n) {
            this.zzabb.zzci(n);
            return this;
        }

        @Deprecated
        public final Builder setMaxAdContentRating(String string) {
            this.zzabb.zzch(string);
            return this;
        }
    }
}

