/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.formats;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.google.android.gms.ads.formats.AdChoicesView;
import com.google.android.gms.ads.formats.MediaView;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.google.android.gms.ads.formats.zzd;
import com.google.android.gms.ads.formats.zze;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzaaw;
import com.google.android.gms.internal.ads.zzacu;
import com.google.android.gms.internal.ads.zzawo;
import com.google.android.gms.internal.ads.zzuo;
import com.google.android.gms.internal.ads.zzyi;
import com.google.android.gms.internal.ads.zzyt;

public final class UnifiedNativeAdView
extends FrameLayout {
    private final FrameLayout zzbkc;
    private final zzaaw zzbkd;

    public UnifiedNativeAdView(Context context) {
        super(context);
        this.zzbkc = this.zzd(context);
        this.zzbkd = this.zzjc();
    }

    public UnifiedNativeAdView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.zzbkc = this.zzd(context);
        this.zzbkd = this.zzjc();
    }

    public UnifiedNativeAdView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.zzbkc = this.zzd(context);
        this.zzbkd = this.zzjc();
    }

    @TargetApi(value=21)
    public UnifiedNativeAdView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.zzbkc = this.zzd(context);
        this.zzbkd = this.zzjc();
    }

    private final void zza(String string, View view) {
        try {
            this.zzbkd.zzc(string, ObjectWrapper.wrap((Object)view));
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zzc("Unable to call setAssetView on delegate", remoteException);
            return;
        }
    }

    public final void setHeadlineView(View view) {
        this.zza("3001", view);
    }

    public final void setCallToActionView(View view) {
        this.zza("3002", view);
    }

    public final void setIconView(View view) {
        this.zza("3003", view);
    }

    public final void setBodyView(View view) {
        this.zza("3004", view);
    }

    public final void setAdvertiserView(View view) {
        this.zza("3005", view);
    }

    public final void setStoreView(View view) {
        this.zza("3006", view);
    }

    public final void setClickConfirmingView(View view) {
        try {
            this.zzbkd.zzi(ObjectWrapper.wrap((Object)view));
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zzc("Unable to call setClickConfirmingView on delegate", remoteException);
            return;
        }
    }

    public final void setPriceView(View view) {
        this.zza("3007", view);
    }

    public final void setImageView(View view) {
        this.zza("3008", view);
    }

    public final void setStarRatingView(View view) {
        this.zza("3009", view);
    }

    public final void setMediaView(MediaView mediaView) {
        this.zza("3010", (View)mediaView);
        if (mediaView != null) {
            mediaView.zza(new zze(this));
            mediaView.zza(new zzd(this));
        }
    }

    public final void setAdChoicesView(AdChoicesView adChoicesView) {
        this.zza("3011", (View)adChoicesView);
    }

    public final void setNativeAd(UnifiedNativeAd unifiedNativeAd) {
        try {
            this.zzbkd.zze((IObjectWrapper)unifiedNativeAd.zzja());
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zzc("Unable to call setNativeAd on delegate", remoteException);
            return;
        }
    }

    private final View zzbk(String string) {
        try {
            IObjectWrapper iObjectWrapper = this.zzbkd.zzcj(string);
            if (iObjectWrapper != null) {
                return (View)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
            }
        }
        catch (RemoteException remoteException) {
            zzawo.zzc("Unable to call getAssetView on delegate", remoteException);
        }
        return null;
    }

    public final View getHeadlineView() {
        return this.zzbk("3001");
    }

    public final View getCallToActionView() {
        return this.zzbk("3002");
    }

    public final View getIconView() {
        return this.zzbk("3003");
    }

    public final View getBodyView() {
        return this.zzbk("3004");
    }

    public final View getStoreView() {
        return this.zzbk("3006");
    }

    public final View getPriceView() {
        return this.zzbk("3007");
    }

    public final View getAdvertiserView() {
        return this.zzbk("3005");
    }

    public final View getImageView() {
        return this.zzbk("3008");
    }

    public final View getStarRatingView() {
        return this.zzbk("3009");
    }

    public final MediaView getMediaView() {
        View view = this.zzbk("3010");
        if (view instanceof MediaView) {
            return (MediaView)view;
        }
        if (view != null) {
            zzawo.zzdv("View is not an instance of MediaView");
        }
        return null;
    }

    public final AdChoicesView getAdChoicesView() {
        View view = this.zzbk("3011");
        if (view instanceof AdChoicesView) {
            return (AdChoicesView)view;
        }
        return null;
    }

    public final void destroy() {
        try {
            this.zzbkd.destroy();
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zzc("Unable to destroy native ad view", remoteException);
            return;
        }
    }

    private final FrameLayout zzd(Context context) {
        Context context2 = context;
        FrameLayout frameLayout = new FrameLayout(context2);
        frameLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.addView((View)frameLayout);
        return frameLayout;
    }

    private final zzaaw zzjc() {
        Preconditions.checkNotNull((Object)this.zzbkc, (Object)"createDelegate must be called after overlayFrame has been created");
        if (this.isInEditMode()) {
            return null;
        }
        return zzuo.zzog().zza(this.zzbkc.getContext(), this, this.zzbkc);
    }

    public final void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        super.addView(view, n, layoutParams);
        super.bringChildToFront((View)this.zzbkc);
    }

    public final void removeView(View view) {
        if (this.zzbkc == view) {
            return;
        }
        super.removeView(view);
    }

    public final void removeAllViews() {
        super.removeAllViews();
        super.addView((View)this.zzbkc);
    }

    public final void bringChildToFront(View view) {
        super.bringChildToFront(view);
        if (this.zzbkc != view) {
            super.bringChildToFront((View)this.zzbkc);
        }
    }

    public final void onVisibilityChanged(View view, int n) {
        super.onVisibilityChanged(view, n);
        if (this.zzbkd != null) {
            try {
                this.zzbkd.zzc(ObjectWrapper.wrap((Object)view), n);
                return;
            }
            catch (RemoteException remoteException) {
                zzawo.zzc("Unable to call onVisibilityChanged on delegate", remoteException);
            }
        }
    }

    public final boolean dispatchTouchEvent(MotionEvent motionEvent) {
        zzyi<Boolean> zzyi2 = zzyt.zzcnh;
        if (zzuo.zzoj().zzd(zzyi2).booleanValue() && this.zzbkd != null) {
            try {
                this.zzbkd.zzj(ObjectWrapper.wrap((Object)motionEvent));
            }
            catch (RemoteException remoteException) {
                zzawo.zzc("Unable to call handleTouchEvent on delegate", remoteException);
            }
        }
        return super.dispatchTouchEvent(motionEvent);
    }

    final /* synthetic */ void zza(ImageView.ScaleType scaleType) {
        try {
            if (scaleType instanceof ImageView.ScaleType) {
                this.zzbkd.zzk(ObjectWrapper.wrap((Object)scaleType));
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zzc("Unable to call setMediaViewImageScaleType on delegate", remoteException);
            return;
        }
    }

    final /* synthetic */ void zza(UnifiedNativeAd.MediaContent mediaContent) {
        try {
            if (mediaContent instanceof zzacu) {
                this.zzbkd.zza(((zzacu)mediaContent).zzqu());
                return;
            }
            if (mediaContent == null) {
                this.zzbkd.zza(null);
                return;
            }
            zzawo.zzdv("Use MediaContent provided by UnifiedNativeAd.getMediaContent");
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zzc("Unable to call setMediaContent on delegate", remoteException);
            return;
        }
    }
}

