/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.IBinder;
import android.os.RemoteException;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.formats.MediaView;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzaao;
import com.google.android.gms.internal.ads.zzaas;
import com.google.android.gms.internal.ads.zzaat;
import com.google.android.gms.internal.ads.zzabo;
import com.google.android.gms.internal.ads.zzawo;
import com.google.android.gms.internal.ads.zzwk;
import java.util.List;
import java.util.WeakHashMap;

public final class zzabp
implements NativeCustomTemplateAd {
    private static WeakHashMap<IBinder, zzabp> zzcvz = new WeakHashMap();
    private final zzabo zzcwa;
    private final MediaView zzcwb;
    private final VideoController zzceg = new VideoController();
    private NativeCustomTemplateAd.DisplayOpenMeasurement zzcwc;

    @VisibleForTesting
    private zzabp(zzabo zzabo2) {
        this.zzcwa = zzabo2;
        Context context = null;
        try {
            context = (Context)ObjectWrapper.unwrap((IObjectWrapper)zzabo2.zzqn());
        }
        catch (RemoteException | NullPointerException throwable) {
            zzawo.zzc("", throwable);
        }
        MediaView mediaView = null;
        if (context != null) {
            Object object = context;
            mediaView = new MediaView((Context)object);
            try {
                if (!this.zzcwa.zzt(ObjectWrapper.wrap((Object)((Object)mediaView)))) {
                    mediaView = null;
                }
            }
            catch (RemoteException remoteException) {
                mediaView = null;
                object = remoteException;
                zzawo.zzc("", (Throwable)object);
            }
        }
        this.zzcwb = mediaView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzabp zza(zzabo zzabo2) {
        WeakHashMap<IBinder, zzabp> weakHashMap = zzcvz;
        synchronized (weakHashMap) {
            zzabp zzabp2 = zzcvz.get(zzabo2.asBinder());
            if (zzabp2 != null) {
                return zzabp2;
            }
            zzabp2 = new zzabp(zzabo2);
            zzcvz.put(zzabo2.asBinder(), zzabp2);
            return zzabp2;
        }
    }

    public final zzabo zzqr() {
        return this.zzcwa;
    }

    @Override
    public final CharSequence getText(String string) {
        try {
            return this.zzcwa.zzco(string);
        }
        catch (RemoteException remoteException) {
            zzawo.zzc("", remoteException);
            return null;
        }
    }

    @Override
    public final NativeAd.Image getImage(String string) {
        try {
            zzaas zzaas2 = this.zzcwa.zzcp(string);
            if (zzaas2 != null) {
                return new zzaat(zzaas2);
            }
        }
        catch (RemoteException remoteException) {
            zzawo.zzc("", remoteException);
        }
        return null;
    }

    @Override
    public final VideoController getVideoController() {
        try {
            zzwk zzwk2 = this.zzcwa.getVideoController();
            if (zzwk2 != null) {
                this.zzceg.zza(zzwk2);
            }
        }
        catch (RemoteException remoteException) {
            zzawo.zzc("Exception occurred while getting video controller", remoteException);
        }
        return this.zzceg;
    }

    @Override
    public final MediaView getVideoMediaView() {
        return this.zzcwb;
    }

    @Override
    public final List<String> getAvailableAssetNames() {
        try {
            return this.zzcwa.getAvailableAssetNames();
        }
        catch (RemoteException remoteException) {
            zzawo.zzc("", remoteException);
            return null;
        }
    }

    @Override
    public final String getCustomTemplateId() {
        try {
            return this.zzcwa.getCustomTemplateId();
        }
        catch (RemoteException remoteException) {
            zzawo.zzc("", remoteException);
            return null;
        }
    }

    @Override
    public final void performClick(String string) {
        try {
            this.zzcwa.performClick(string);
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zzc("", remoteException);
            return;
        }
    }

    @Override
    public final void recordImpression() {
        try {
            this.zzcwa.recordImpression();
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zzc("", remoteException);
            return;
        }
    }

    @Override
    public final NativeCustomTemplateAd.DisplayOpenMeasurement getDisplayOpenMeasurement() {
        try {
            if (this.zzcwc == null && this.zzcwa.zzqo()) {
                this.zzcwc = new zzaao(this.zzcwa);
            }
        }
        catch (RemoteException remoteException) {
            zzawo.zzc("", remoteException);
        }
        return this.zzcwc;
    }

    @Override
    public final void destroy() {
        try {
            this.zzcwa.destroy();
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zzc("", remoteException);
            return;
        }
    }
}

