/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.RemoteException;
import androidx.annotation.Nullable;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.mediation.MediationBannerAdapter;
import com.google.android.gms.ads.mediation.MediationBannerListener;
import com.google.android.gms.ads.mediation.MediationInterstitialAdapter;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.google.android.gms.ads.mediation.MediationNativeAdapter;
import com.google.android.gms.ads.mediation.MediationNativeListener;
import com.google.android.gms.ads.mediation.NativeAdMapper;
import com.google.android.gms.ads.mediation.UnifiedNativeAdMapper;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzabp;
import com.google.android.gms.internal.ads.zzajj;
import com.google.android.gms.internal.ads.zzajx;
import com.google.android.gms.internal.ads.zzawo;

public final class zzake
implements MediationBannerListener,
MediationInterstitialListener,
MediationNativeListener {
    private final zzajj zzddq;
    private NativeAdMapper zzddr;
    private UnifiedNativeAdMapper zzdds;
    private NativeCustomTemplateAd zzddt;

    public zzake(zzajj zzajj2) {
        this.zzddq = zzajj2;
    }

    @Override
    public final void zza(MediationBannerAdapter mediationBannerAdapter, String string, String string2) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzawo.zzdv("Adapter called onAppEvent.");
        try {
            this.zzddq.onAppEvent(string, string2);
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClicked(MediationBannerAdapter mediationBannerAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzawo.zzdv("Adapter called onAdClicked.");
        try {
            this.zzddq.onAdClicked();
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClosed(MediationBannerAdapter mediationBannerAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzawo.zzdv("Adapter called onAdClosed.");
        try {
            this.zzddq.onAdClosed();
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdFailedToLoad(MediationBannerAdapter mediationBannerAdapter, int n) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzawo.zzdv(new StringBuilder(55).append("Adapter called onAdFailedToLoad with error. ").append(n).toString());
        try {
            this.zzddq.onAdFailedToLoad(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLeftApplication(MediationBannerAdapter mediationBannerAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzawo.zzdv("Adapter called onAdLeftApplication.");
        try {
            this.zzddq.onAdLeftApplication();
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdOpened(MediationBannerAdapter mediationBannerAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzawo.zzdv("Adapter called onAdOpened.");
        try {
            this.zzddq.onAdOpened();
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLoaded(MediationBannerAdapter mediationBannerAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzawo.zzdv("Adapter called onAdLoaded.");
        try {
            this.zzddq.onAdLoaded();
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClicked(MediationInterstitialAdapter mediationInterstitialAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzawo.zzdv("Adapter called onAdClicked.");
        try {
            this.zzddq.onAdClicked();
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClosed(MediationInterstitialAdapter mediationInterstitialAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzawo.zzdv("Adapter called onAdClosed.");
        try {
            this.zzddq.onAdClosed();
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdFailedToLoad(MediationInterstitialAdapter mediationInterstitialAdapter, int n) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzawo.zzdv(new StringBuilder(55).append("Adapter called onAdFailedToLoad with error ").append(n).append(".").toString());
        try {
            this.zzddq.onAdFailedToLoad(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLeftApplication(MediationInterstitialAdapter mediationInterstitialAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzawo.zzdv("Adapter called onAdLeftApplication.");
        try {
            this.zzddq.onAdLeftApplication();
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdOpened(MediationInterstitialAdapter mediationInterstitialAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzawo.zzdv("Adapter called onAdOpened.");
        try {
            this.zzddq.onAdOpened();
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLoaded(MediationInterstitialAdapter mediationInterstitialAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzawo.zzdv("Adapter called onAdLoaded.");
        try {
            this.zzddq.onAdLoaded();
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLoaded(MediationNativeAdapter mediationNativeAdapter, NativeAdMapper nativeAdMapper) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzawo.zzdv("Adapter called onAdLoaded.");
        this.zzddr = nativeAdMapper;
        this.zzdds = null;
        zzake.zza(mediationNativeAdapter, this.zzdds, this.zzddr);
        try {
            this.zzddq.onAdLoaded();
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLoaded(MediationNativeAdapter mediationNativeAdapter, UnifiedNativeAdMapper unifiedNativeAdMapper) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzawo.zzdv("Adapter called onAdLoaded.");
        this.zzdds = unifiedNativeAdMapper;
        this.zzddr = null;
        zzake.zza(mediationNativeAdapter, this.zzdds, this.zzddr);
        try {
            this.zzddq.onAdLoaded();
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    private static void zza(MediationNativeAdapter mediationNativeAdapter, @Nullable UnifiedNativeAdMapper unifiedNativeAdMapper, @Nullable NativeAdMapper nativeAdMapper) {
        if (mediationNativeAdapter instanceof AdMobAdapter) {
            return;
        }
        VideoController videoController = new VideoController();
        videoController.zza(new zzajx());
        if (unifiedNativeAdMapper != null && unifiedNativeAdMapper.hasVideoContent()) {
            unifiedNativeAdMapper.zza(videoController);
        }
        if (nativeAdMapper != null && nativeAdMapper.hasVideoContent()) {
            nativeAdMapper.zza(videoController);
        }
    }

    @Override
    public final void zza(MediationNativeAdapter mediationNativeAdapter, NativeCustomTemplateAd nativeCustomTemplateAd) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        String string = String.valueOf(nativeCustomTemplateAd.getCustomTemplateId());
        zzawo.zzdv(string.length() != 0 ? "Adapter called onAdLoaded with template id ".concat(string) : new String("Adapter called onAdLoaded with template id "));
        this.zzddt = nativeCustomTemplateAd;
        try {
            this.zzddq.onAdLoaded();
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void zza(MediationNativeAdapter mediationNativeAdapter, NativeCustomTemplateAd nativeCustomTemplateAd, String string) {
        if (nativeCustomTemplateAd instanceof zzabp) {
            try {
                this.zzddq.zza(((zzabp)nativeCustomTemplateAd).zzqr(), string);
                return;
            }
            catch (RemoteException remoteException) {
                zzawo.zze("#007 Could not call remote method.", remoteException);
                return;
            }
        }
        zzawo.zzeu("Unexpected native custom template ad type.");
    }

    @Override
    public final void onAdFailedToLoad(MediationNativeAdapter mediationNativeAdapter, int n) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzawo.zzdv(new StringBuilder(55).append("Adapter called onAdFailedToLoad with error ").append(n).append(".").toString());
        try {
            this.zzddq.onAdFailedToLoad(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdOpened(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzawo.zzdv("Adapter called onAdOpened.");
        try {
            this.zzddq.onAdOpened();
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClosed(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzawo.zzdv("Adapter called onAdClosed.");
        try {
            this.zzddq.onAdClosed();
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLeftApplication(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzawo.zzdv("Adapter called onAdLeftApplication.");
        try {
            this.zzddq.onAdLeftApplication();
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClicked(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        NativeAdMapper nativeAdMapper = this.zzddr;
        UnifiedNativeAdMapper unifiedNativeAdMapper = this.zzdds;
        if (this.zzddt == null) {
            if (nativeAdMapper == null && unifiedNativeAdMapper == null) {
                zzawo.zze("#007 Could not call remote method.", null);
                return;
            }
            if (unifiedNativeAdMapper != null && !unifiedNativeAdMapper.getOverrideClickHandling()) {
                zzawo.zzdv("Could not call onAdClicked since setOverrideClickHandling is not set to true");
                return;
            }
            if (nativeAdMapper != null && !nativeAdMapper.getOverrideClickHandling()) {
                zzawo.zzdv("Could not call onAdClicked since setOverrideClickHandling is not set to true");
                return;
            }
        }
        zzawo.zzdv("Adapter called onAdClicked.");
        try {
            this.zzddq.onAdClicked();
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdImpression(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        NativeAdMapper nativeAdMapper = this.zzddr;
        UnifiedNativeAdMapper unifiedNativeAdMapper = this.zzdds;
        if (this.zzddt == null) {
            if (nativeAdMapper == null && unifiedNativeAdMapper == null) {
                zzawo.zze("#007 Could not call remote method.", null);
                return;
            }
            if (unifiedNativeAdMapper != null && !unifiedNativeAdMapper.getOverrideImpressionRecording()) {
                zzawo.zzdv("Could not call onAdImpression since setOverrideImpressionRecording is not set to true");
                return;
            }
            if (nativeAdMapper != null && !nativeAdMapper.getOverrideImpressionRecording()) {
                zzawo.zzdv("Could not call onAdImpression since setOverrideImpressionRecording is not set to true");
                return;
            }
        }
        zzawo.zzdv("Adapter called onAdImpression.");
        try {
            this.zzddq.onAdImpression();
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onVideoEnd(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzawo.zzdv("Adapter called onVideoEnd.");
        try {
            this.zzddq.onVideoEnd();
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final NativeAdMapper zzrw() {
        return this.zzddr;
    }

    public final UnifiedNativeAdMapper zzrx() {
        return this.zzdds;
    }

    public final NativeCustomTemplateAd zzry() {
        return this.zzddt;
    }
}

