/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Looper;
import android.text.TextUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.ads.zzanm;
import com.google.android.gms.internal.ads.zzano;
import com.google.android.gms.internal.ads.zzanp;
import com.google.android.gms.internal.ads.zzanq;
import com.google.android.gms.internal.ads.zzanr;
import com.google.android.gms.internal.ads.zzawe;
import com.google.android.gms.internal.ads.zzawo;
import com.google.android.gms.internal.ads.zzaws;
import com.google.android.gms.internal.ads.zzawv;
import com.google.android.gms.internal.ads.zzczf;
import com.google.android.gms.internal.ads.zzczk;
import com.google.android.gms.internal.ads.zzdof;
import com.google.android.gms.internal.ads.zzuo;
import com.google.android.gms.internal.ads.zzyi;
import com.google.android.gms.internal.ads.zzyt;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class zzann
implements zzanr {
    private static final Object lock = new Object();
    @VisibleForTesting
    private static zzanr zzdhz = null;
    @VisibleForTesting
    private static zzanr zzdia = null;
    private final Object zzdib = new Object();
    private final Context zzcft;
    private final WeakHashMap<Thread, Boolean> zzdic = new WeakHashMap();
    private final ExecutorService zzxr = zzczf.zzanz().zzdo(zzczk.zzgny);
    private final zzawv zzdid;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzanr zzr(Context context) {
        Object object = lock;
        synchronized (object) {
            if (zzdhz == null) {
                zzyi<Boolean> zzyi2 = zzyt.zzcgi;
                zzdhz = zzuo.zzoj().zzd(zzyi2) != false ? new zzann(context) : new zzanq();
            }
        }
        return zzdhz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzanr zzc(Context context, zzawv zzawv2) {
        Object object = lock;
        synchronized (object) {
            if (zzdia == null) {
                Object object2 = zzyt.zzcgi;
                if (zzuo.zzoj().zzd(object2).booleanValue()) {
                    zzann zzann2 = new zzann(context, zzawv2);
                    Thread thread = Looper.getMainLooper().getThread();
                    zzann zzann3 = zzann2;
                    if (thread != null) {
                        Object object3 = zzann3.zzdib;
                        synchronized (object3) {
                            zzann3.zzdic.put(thread, true);
                        }
                        object3 = thread.getUncaughtExceptionHandler();
                        thread.setUncaughtExceptionHandler(new zzano(zzann3, (Thread.UncaughtExceptionHandler)object3));
                    }
                    object2 = zzann2;
                    Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
                    Thread.setDefaultUncaughtExceptionHandler(new zzanp((zzann)object2, uncaughtExceptionHandler));
                    zzdia = zzann2;
                } else {
                    zzdia = new zzanq();
                }
            }
        }
        return zzdia;
    }

    private zzann(Context context) {
        this(context, zzawv.zzwk());
    }

    private zzann(Context context, zzawv zzawv2) {
        this.zzcft = context.getApplicationContext() != null ? context.getApplicationContext() : context;
        this.zzdid = zzawv2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void zza(Thread thread, Throwable throwable) {
        Throwable throwable2;
        zzann zzann2 = this;
        if (throwable2 == null) return;
        boolean bl = false;
        boolean bl2 = false;
        for (throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            for (StackTraceElement stackTraceElement : throwable2.getStackTrace()) {
                if (zzawe.zzeo(stackTraceElement.getClassName())) {
                    bl = true;
                }
                if (!zzann2.getClass().getName().equals(stackTraceElement.getClassName())) continue;
                bl2 = true;
            }
        }
        if (!bl) return;
        if (bl2) return;
        boolean bl3 = true;
        if (!bl3) return;
        throwable2 = throwable;
        String string = "";
        Throwable throwable3 = throwable2;
        this.zza(throwable2, string, 1.0f);
    }

    @Override
    public final void zza(Throwable throwable, String string) {
        this.zza(throwable, string, 1.0f);
    }

    @Override
    public final void zza(Throwable throwable, String string, float f) {
        if (zzawe.zzc(throwable) == null) {
            return;
        }
        String string2 = throwable.getClass().getName();
        StringWriter stringWriter = new StringWriter();
        zzdof.zza((Throwable)throwable, (PrintWriter)new PrintWriter(stringWriter));
        String string3 = stringWriter.toString();
        boolean bl = Math.random() < (double)f;
        int n = f > 0.0f ? (int)(1.0f / f) : 1;
        if (bl) {
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = n;
            String string4 = string;
            String string5 = string3;
            Object object = string2;
            arrayList.add(this.zza((String)object, string5, string4, n2).toString());
            object = arrayList;
            zzann zzann2 = this;
            ArrayList arrayList2 = (ArrayList)object;
            int n3 = arrayList2.size();
            string5 = null;
            for (int i = 0; i < n3; ++i) {
                Object e = arrayList2.get(i);
                string4 = (String)e;
                zzaws zzaws2 = new zzaws();
                zzann2.zzxr.execute(new zzanm(zzaws2, string4));
            }
        }
    }

    @VisibleForTesting
    private final Uri.Builder zza(String string, String string2, String string3, int n) {
        boolean bl = false;
        try {
            bl = Wrappers.packageManager((Context)this.zzcft).isCallerInstantApp();
        }
        catch (Throwable throwable) {
            zzawo.zzc("Error fetching instant app info", throwable);
        }
        String string4 = "unknown";
        try {
            string4 = this.zzcft.getPackageName();
        }
        catch (Throwable throwable) {
            zzawo.zzeu("Cannot obtain package name, proceeding.");
        }
        String string5 = Build.MANUFACTURER;
        String string6 = Build.MODEL;
        zzyi<String> zzyi2 = zzyt.zzcsd;
        return new Uri.Builder().scheme("https").path("//pagead2.googlesyndication.com/pagead/gen_204").appendQueryParameter("is_aia", Boolean.toString(bl)).appendQueryParameter("id", "gmob-apps-report-exception").appendQueryParameter("os", Build.VERSION.RELEASE).appendQueryParameter("api", String.valueOf(Build.VERSION.SDK_INT)).appendQueryParameter("device", string6.startsWith(string5) ? string6 : new StringBuilder(1 + String.valueOf(string5).length() + String.valueOf(string6).length()).append(string5).append(" ").append(string6).toString()).appendQueryParameter("js", this.zzdid.zzbnh).appendQueryParameter("appid", string4).appendQueryParameter("exceptiontype", string).appendQueryParameter("stacktrace", string2).appendQueryParameter("eids", TextUtils.join((CharSequence)",", zzyt.zzpn())).appendQueryParameter("exceptionkey", string3).appendQueryParameter("cl", "258870853").appendQueryParameter("rc", "dev").appendQueryParameter("session_id", zzuo.zzok()).appendQueryParameter("sampling_rate", Integer.toString(n)).appendQueryParameter("pb_tm", String.valueOf(zzuo.zzoj().zzd(zzyi2)));
    }

    static final /* synthetic */ void zza(zzaws zzaws2, String string) {
        zzaws2.zzei(string);
    }
}

