/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.InterstitialAd;
import com.google.android.gms.ads.doubleclick.PublisherAdView;
import com.google.android.gms.ads.doubleclick.PublisherInterstitialAd;
import com.google.android.gms.ads.search.SearchAdView;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzawh;
import com.google.android.gms.internal.ads.zzawj;
import com.google.android.gms.internal.ads.zzawo;
import com.google.android.gms.internal.ads.zzczj;
import com.google.android.gms.internal.ads.zztw;
import com.google.android.gms.internal.ads.zzuo;
import com.google.android.gms.internal.ads.zzyi;
import com.google.android.gms.internal.ads.zzyt;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.UUID;

public final class zzawe {
    public static final Handler zzzb = new zzczj(Looper.getMainLooper());
    private static final String zzdva = AdView.class.getName();
    private static final String zzdvb = InterstitialAd.class.getName();
    private static final String zzdvc = PublisherAdView.class.getName();
    private static final String zzdvd = PublisherInterstitialAd.class.getName();
    private static final String zzdve = SearchAdView.class.getName();
    private static final String zzdvf = AdLoader.class.getName();
    private float zzdvg = -1.0f;

    public static void zza(boolean bl, HttpURLConnection httpURLConnection, @Nullable String string) {
        httpURLConnection.setConnectTimeout(60000);
        httpURLConnection.setInstanceFollowRedirects(true);
        httpURLConnection.setReadTimeout(60000);
        if (string != null) {
            httpURLConnection.setRequestProperty("User-Agent", string);
        }
        httpURLConnection.setUseCaches(false);
    }

    public static int zza(Context context, int n) {
        return zzawe.zza(context.getResources().getDisplayMetrics(), n);
    }

    public static int zza(DisplayMetrics displayMetrics, int n) {
        return (int)TypedValue.applyDimension((int)1, (float)n, (DisplayMetrics)displayMetrics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int zzb(Context context, int n) {
        if (this.zzdvg < 0.0f) {
            zzawe zzawe2 = this;
            synchronized (zzawe2) {
                if (this.zzdvg < 0.0f) {
                    Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
                    DisplayMetrics displayMetrics = new DisplayMetrics();
                    display.getMetrics(displayMetrics);
                    this.zzdvg = displayMetrics.density;
                }
            }
        }
        return Math.round((float)n / this.zzdvg);
    }

    public static int zzb(DisplayMetrics displayMetrics, int n) {
        return Math.round((float)n / displayMetrics.density);
    }

    public final void zza(ViewGroup viewGroup, zztw zztw2, String string, String string2) {
        zzawo.zzeu(string2);
        this.zza(viewGroup, zztw2, string, -65536, -16777216);
    }

    public final void zza(ViewGroup viewGroup, zztw zztw2, String string) {
        this.zza(viewGroup, zztw2, string, -16777216, -1);
    }

    private final void zza(ViewGroup viewGroup, zztw zztw2, String string, int n, int n2) {
        if (viewGroup.getChildCount() != 0) {
            return;
        }
        Context context = viewGroup.getContext();
        TextView textView = new TextView(context);
        textView.setGravity(17);
        textView.setText((CharSequence)string);
        textView.setTextColor(n);
        textView.setBackgroundColor(n2);
        FrameLayout frameLayout = new FrameLayout(context);
        frameLayout.setBackgroundColor(n);
        int n3 = zzawe.zza(context, 3);
        frameLayout.addView((View)textView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(zztw2.widthPixels - n3, zztw2.heightPixels - n3, 17));
        viewGroup.addView((View)frameLayout, zztw2.widthPixels, zztw2.heightPixels);
    }

    public static String zzbh(Context context) {
        ContentResolver contentResolver = context.getContentResolver();
        String string = contentResolver == null ? null : Settings.Secure.getString((ContentResolver)contentResolver, (String)"android_id");
        return zzawe.zzen(string == null || zzawe.zzwb() ? "emulator" : string);
    }

    @Nullable
    public static String zzbi(Context context) {
        ContentResolver contentResolver = context.getContentResolver();
        if (contentResolver == null) {
            return null;
        }
        return Settings.Secure.getString((ContentResolver)contentResolver, (String)"android_id");
    }

    public static boolean zzwb() {
        return Build.DEVICE.startsWith("generic");
    }

    public static boolean zzwc() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public static String zzen(String string) {
        for (int i = 0; i < 2; ++i) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                messageDigest.update(string.getBytes());
                return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest()));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                continue;
            }
            catch (ArithmeticException arithmeticException) {
                return null;
            }
        }
        return null;
    }

    public static boolean zzc(Context context, int n) {
        return 0 == GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(context, n);
    }

    public static boolean zzbj(Context context) {
        int n = GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(context, 12451000);
        return n == 0 || n == 2;
    }

    public static boolean zzbk(Context context) {
        if (context.getResources().getConfiguration().orientation != 2) {
            return false;
        }
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return (int)((float)displayMetrics.heightPixels / displayMetrics.density) < 600;
    }

    @TargetApi(value=17)
    public static boolean zzbl(Context context) {
        int n;
        int n2;
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
        if (PlatformVersion.isAtLeastJellyBeanMR1()) {
            display.getRealMetrics(displayMetrics);
            n2 = displayMetrics.heightPixels;
            n = displayMetrics.widthPixels;
        } else {
            try {
                n2 = (Integer)Display.class.getMethod("getRawHeight", new Class[0]).invoke((Object)display, new Object[0]);
                n = (Integer)Display.class.getMethod("getRawWidth", new Class[0]).invoke((Object)display, new Object[0]);
            }
            catch (Exception exception) {
                return false;
            }
        }
        display.getMetrics(displayMetrics);
        int n3 = displayMetrics.heightPixels;
        int n4 = displayMetrics.widthPixels;
        return n3 == n2 && n4 == n;
    }

    public static int zzbm(Context context) {
        int n = context.getResources().getIdentifier("navigation_bar_width", "dimen", "android");
        if (n > 0) {
            return context.getResources().getDimensionPixelSize(n);
        }
        return 0;
    }

    @Nullable
    @VisibleForTesting
    public static String zza(StackTraceElement[] stackTraceElementArray, String string) {
        String string2 = null;
        int n = 0;
        while (n + 1 < stackTraceElementArray.length) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n];
            String string3 = stackTraceElement.getClassName();
            String string4 = stackTraceElement.getMethodName();
            if ("loadAd".equalsIgnoreCase(string4) && (zzdva.equalsIgnoreCase(string3) || zzdvb.equalsIgnoreCase(string3) || zzdvc.equalsIgnoreCase(string3) || zzdvd.equalsIgnoreCase(string3) || zzdve.equalsIgnoreCase(string3) || zzdvf.equalsIgnoreCase(string3))) {
                string2 = stackTraceElementArray[n + 1].getClassName();
                break;
            }
            ++n;
        }
        if (string != null) {
            String string5;
            String string6;
            int n2 = 3;
            String string7 = ".";
            String string8 = string;
            StringTokenizer stringTokenizer = new StringTokenizer(string8, string7);
            StringBuilder stringBuilder = new StringBuilder();
            --n2;
            if (!stringTokenizer.hasMoreElements()) {
                string6 = string8;
            } else {
                stringBuilder.append(stringTokenizer.nextToken());
                while (n2-- > 0 && stringTokenizer.hasMoreElements()) {
                    stringBuilder.append(".").append(stringTokenizer.nextToken());
                }
                string6 = string5 = stringBuilder.toString();
            }
            if (string2 != null && !string2.contains(string5)) {
                return string2;
            }
        }
        return null;
    }

    public final void zza(Context context, @Nullable String string, String string2, Bundle bundle, boolean bl) {
        zzawe.zza(context, string, string2, bundle, true, new zzawh(this));
    }

    public static void zza(Context context, @Nullable String string, String string2, Bundle bundle, boolean bl, zzawj zzawj2) {
        Context context2 = context.getApplicationContext();
        if (context2 == null) {
            context2 = context;
        }
        bundle.putString("os", Build.VERSION.RELEASE);
        bundle.putString("api", String.valueOf(Build.VERSION.SDK_INT));
        bundle.putString("appid", context2.getPackageName());
        if (string == null) {
            int n = GoogleApiAvailabilityLight.getInstance().getApkVersion(context);
            string = new StringBuilder(23).append(n).append(".15301000").toString();
        }
        bundle.putString("js", string);
        context2 = new Uri.Builder().scheme("https").path("//pagead2.googlesyndication.com/pagead/gen_204").appendQueryParameter("id", string2);
        for (String string3 : bundle.keySet()) {
            context2.appendQueryParameter(string3, bundle.getString(string3));
        }
        zzawj2.zzei(context2.toString());
    }

    public static String zzwd() {
        UUID uUID = UUID.randomUUID();
        byte[] byArray = BigInteger.valueOf(uUID.getLeastSignificantBits()).toByteArray();
        byte[] byArray2 = BigInteger.valueOf(uUID.getMostSignificantBits()).toByteArray();
        String string = new BigInteger(1, byArray).toString();
        for (int i = 0; i < 2; ++i) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                messageDigest.update(byArray);
                messageDigest.update(byArray2);
                byte[] byArray3 = new byte[8];
                System.arraycopy(messageDigest.digest(), 0, byArray3, 0, 8);
                string = new BigInteger(1, byArray3).toString();
                continue;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
        return string;
    }

    public static Throwable zzc(Throwable throwable) {
        Throwable throwable2;
        Object object = zzyt.zzcgk;
        if (zzuo.zzoj().zzd(object).booleanValue()) {
            return throwable;
        }
        LinkedList<Throwable> linkedList = new LinkedList<Throwable>();
        for (throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            linkedList.push(throwable2);
        }
        Throwable throwable3 = null;
        while (!linkedList.isEmpty()) {
            throwable2 = (Throwable)linkedList.pop();
            StackTraceElement[] stackTraceElementArray = throwable2.getStackTrace();
            ArrayList<StackTraceElement> arrayList = new ArrayList<StackTraceElement>();
            arrayList.add(new StackTraceElement(throwable2.getClass().getName(), "<filtered>", "<filtered>", 1));
            boolean bl = false;
            StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
            int n = stackTraceElementArray.length;
            for (int i = 0; i < n; ++i) {
                StackTraceElement stackTraceElement = stackTraceElementArray2[i];
                if (zzawe.zzeo(stackTraceElement.getClassName())) {
                    bl = true;
                    arrayList.add(stackTraceElement);
                    continue;
                }
                object = stackTraceElement.getClassName();
                if (!TextUtils.isEmpty((CharSequence)object) && (((String)object).startsWith("android.") || ((String)object).startsWith("java."))) {
                    arrayList.add(stackTraceElement);
                    continue;
                }
                StackTraceElement stackTraceElement2 = new StackTraceElement("<filtered>", "<filtered>", "<filtered>", 1);
                arrayList.add(stackTraceElement2);
            }
            if (!bl) continue;
            throwable3 = throwable3 == null ? new Throwable(throwable2.getMessage()) : new Throwable(throwable2.getMessage(), throwable3);
            throwable3.setStackTrace(arrayList.toArray(new StackTraceElement[0]));
        }
        return throwable3;
    }

    public static AdSize zza(Context context, int n, int n2, int n3) {
        if (context == null) {
            return AdSize.INVALID;
        }
        Resources resources = (context.getApplicationContext() != null ? context.getApplicationContext() : context).getResources();
        if (resources == null) {
            return AdSize.INVALID;
        }
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        if (displayMetrics == null) {
            return AdSize.INVALID;
        }
        Configuration configuration = resources.getConfiguration();
        if (configuration == null) {
            return AdSize.INVALID;
        }
        int n4 = configuration.orientation;
        if (n3 == 0) {
            n3 = n4;
        }
        DisplayMetrics displayMetrics2 = displayMetrics;
        int n5 = n4;
        int n6 = n3 == n5 ? Math.round((float)displayMetrics2.heightPixels / displayMetrics2.density) : Math.round((float)displayMetrics2.widthPixels / displayMetrics2.density);
        int n7 = Math.min(90, Math.round((float)n6 * 0.15f));
        int n8 = n > 655 ? Math.round((float)n / 728.0f * 90.0f) : (n > 632 ? 81 : (n > 526 ? Math.round((float)n / 468.0f * 60.0f) : (n > 432 ? 68 : Math.round((float)n / 320.0f * 50.0f))));
        n8 = Math.max(Math.min(n8, n7), 50);
        return new AdSize(n, n8);
    }

    @VisibleForTesting
    public static boolean zzeo(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        zzyi<String> zzyi2 = zzyt.zzcgl;
        return string.startsWith(zzuo.zzoj().zzd(zzyi2));
    }
}

