/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.ads.zzawe;
import com.google.android.gms.internal.ads.zztv;
import com.google.android.gms.internal.ads.zzuo;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="AdSizeParcelCreator")
public final class zztw
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<zztw> CREATOR = new zztv();
    @SafeParcelable.Field(id=2)
    public final String zzabd;
    @SafeParcelable.Field(id=3)
    public final int height;
    @SafeParcelable.Field(id=4)
    public final int heightPixels;
    @SafeParcelable.Field(id=5)
    public final boolean zzcce;
    @SafeParcelable.Field(id=6)
    public final int width;
    @SafeParcelable.Field(id=7)
    public final int widthPixels;
    @SafeParcelable.Field(id=8)
    public final zztw[] zzccf;
    @SafeParcelable.Field(id=9)
    public final boolean zzbnj;
    @SafeParcelable.Field(id=10)
    public final boolean zzccg;
    @SafeParcelable.Field(id=11)
    public boolean zzcch;
    @SafeParcelable.Field(id=12)
    public boolean zzcci;
    @SafeParcelable.Field(id=13)
    private boolean zzccj;
    @SafeParcelable.Field(id=14)
    public boolean zzcck;

    public static int zzb(DisplayMetrics displayMetrics) {
        return displayMetrics.widthPixels;
    }

    public static int zzc(DisplayMetrics displayMetrics) {
        return (int)((float)zztw.zzd(displayMetrics) * displayMetrics.density);
    }

    private static int zzd(DisplayMetrics displayMetrics) {
        int n = (int)((float)displayMetrics.heightPixels / displayMetrics.density);
        if (n <= 400) {
            return 32;
        }
        if (n <= 720) {
            return 50;
        }
        return 90;
    }

    public static zztw zzg(Context context) {
        return new zztw("320x50_mb", 0, 0, false, 0, 0, null, true, false, false, false, false, false);
    }

    public static zztw zzny() {
        return new zztw("reward_mb", 0, 0, true, 0, 0, null, false, false, false, false, false, false);
    }

    public zztw() {
        this("interstitial_mb", 0, 0, true, 0, 0, null, false, false, false, false, false, false);
    }

    public static zztw zznz() {
        return new zztw("invalid", 0, 0, false, 0, 0, null, false, false, false, true, false, false);
    }

    public zztw(Context context, AdSize adSize) {
        this(context, new AdSize[]{adSize});
    }

    /*
     * Unable to fully structure code
     */
    public zztw(Context var1_1, AdSize[] var2_2) {
        block11: {
            block10: {
                super();
                var3_3 = var2_2[0];
                this.zzcce = false;
                this.zzccg = var3_3.isFluid();
                this.zzcck = var3_3.zzdb();
                if (this.zzccg) {
                    this.width = AdSize.BANNER.getWidth();
                    this.height = AdSize.BANNER.getHeight();
                } else {
                    this.width = var3_3.getWidth();
                    this.height = var3_3.getHeight();
                }
                var4_4 = this.width == -1;
                var5_5 = this.height == -2;
                var6_6 = var1_1.getResources().getDisplayMetrics();
                if (!var4_4) break block10;
                zzuo.zzof();
                if (!zzawe.zzbk(var1_1)) ** GOTO lbl-1000
                zzuo.zzof();
                if (zzawe.zzbl(var1_1)) {
                    v0 = var6_6.widthPixels;
                    zzuo.zzof();
                    this.widthPixels = v0 - zzawe.zzbm(var1_1);
                } else lbl-1000:
                // 2 sources

                {
                    this.widthPixels = var6_6.widthPixels;
                }
                var9_7 = (float)this.widthPixels / var6_6.density;
                var7_10 = (int)var9_7;
                if (var9_7 - (double)((int)var9_7) >= 0.01) {
                    ++var7_10;
                }
                break block11;
            }
            var7_10 = this.width;
            zzuo.zzof();
            this.widthPixels = zzawe.zza(var6_6, this.width);
        }
        var8_11 = var5_5 != false ? zztw.zzd(var6_6) : this.height;
        zzuo.zzof();
        this.heightPixels = zzawe.zza(var6_6, var8_11);
        if (var4_4 || var5_5) {
            var9_8 = var7_10;
            this.zzabd = new StringBuilder(26).append(var9_8).append("x").append(var8_11).append("_as").toString();
        } else {
            this.zzabd = this.zzccg != false ? "320x50_mb" : var3_3.toString();
        }
        if (var2_2.length > 1) {
            this.zzccf = new zztw[var2_2.length];
            for (var9_9 = 0; var9_9 < var2_2.length; ++var9_9) {
                this.zzccf[var9_9] = new zztw(var1_1, var2_2[var9_9]);
            }
        } else {
            this.zzccf = null;
        }
        this.zzbnj = false;
        this.zzcch = false;
    }

    @SafeParcelable.Constructor
    zztw(@SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) int n, @SafeParcelable.Param(id=4) int n2, @SafeParcelable.Param(id=5) boolean bl, @SafeParcelable.Param(id=6) int n3, @SafeParcelable.Param(id=7) int n4, @SafeParcelable.Param(id=8) zztw[] zztwArray, @SafeParcelable.Param(id=9) boolean bl2, @SafeParcelable.Param(id=10) boolean bl3, @SafeParcelable.Param(id=11) boolean bl4, @SafeParcelable.Param(id=12) boolean bl5, @SafeParcelable.Param(id=13) boolean bl6, @SafeParcelable.Param(id=14) boolean bl7) {
        this.zzabd = string;
        this.height = n;
        this.heightPixels = n2;
        this.zzcce = bl;
        this.width = n3;
        this.widthPixels = n4;
        this.zzccf = zztwArray;
        this.zzbnj = bl2;
        this.zzccg = bl3;
        this.zzcch = bl4;
        this.zzcci = bl5;
        this.zzccj = bl6;
        this.zzcck = bl7;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zztw zztw2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)zztw2.zzabd, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)3, (int)zztw2.height);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)4, (int)zztw2.heightPixels);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)5, (boolean)zztw2.zzcce);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)6, (int)zztw2.width);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)7, (int)zztw2.widthPixels);
        SafeParcelWriter.writeTypedArray((Parcel)parcel2, (int)8, (Parcelable[])zztw2.zzccf, (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)9, (boolean)zztw2.zzbnj);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)10, (boolean)zztw2.zzccg);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)11, (boolean)zztw2.zzcch);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)12, (boolean)zztw2.zzcci);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)13, (boolean)zztw2.zzccj);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)14, (boolean)zztw2.zzcck);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }
}

