/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.ads.zzb;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzaje;
import com.google.android.gms.internal.ads.zzawe;
import com.google.android.gms.internal.ads.zzawo;
import com.google.android.gms.internal.ads.zzth;
import com.google.android.gms.internal.ads.zztk;
import com.google.android.gms.internal.ads.zztl;
import com.google.android.gms.internal.ads.zztu;
import com.google.android.gms.internal.ads.zztw;
import com.google.android.gms.internal.ads.zzty;
import com.google.android.gms.internal.ads.zztz;
import com.google.android.gms.internal.ads.zzub;
import com.google.android.gms.internal.ads.zzuc;
import com.google.android.gms.internal.ads.zzug;
import com.google.android.gms.internal.ads.zzun;
import com.google.android.gms.internal.ads.zzuo;
import com.google.android.gms.internal.ads.zzve;
import com.google.android.gms.internal.ads.zzwk;
import com.google.android.gms.internal.ads.zzws;
import com.google.android.gms.internal.ads.zzwt;
import com.google.android.gms.internal.ads.zzyc;
import com.google.android.gms.internal.ads.zzzs;
import java.util.concurrent.atomic.AtomicBoolean;

public final class zzwu {
    private final zzaje zzcee = new zzaje();
    private final zztu zzaax;
    private final AtomicBoolean zzcef;
    private final VideoController zzceg = new VideoController();
    @VisibleForTesting
    private final zzun zzceh = new zzwt(this);
    private zzth zzcbl;
    private AdListener zzcbm;
    private AdSize[] zzccl;
    private AppEventListener zzbkg;
    private zzve zzcei;
    private OnCustomRenderedAdLoadedListener zzcej;
    private VideoOptions zzbjx;
    private String zzccm;
    private ViewGroup zzcek;
    private int zzcel;
    private boolean zzbke;

    public zzwu(ViewGroup viewGroup) {
        this(viewGroup, null, false, zztu.zzccd, 0);
    }

    public zzwu(ViewGroup viewGroup, int n) {
        this(viewGroup, null, false, zztu.zzccd, n);
    }

    public zzwu(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl) {
        this(viewGroup, attributeSet, bl, zztu.zzccd, 0);
    }

    public zzwu(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, int n) {
        this(viewGroup, attributeSet, false, zztu.zzccd, n);
    }

    @VisibleForTesting
    private zzwu(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zztu zztu2, zzve zzve2, int n) {
        this.zzcek = viewGroup;
        this.zzaax = zztu2;
        this.zzcei = null;
        this.zzcef = new AtomicBoolean(false);
        this.zzcel = n;
        if (attributeSet != null) {
            Context context = viewGroup.getContext();
            try {
                zztz zztz2 = new zztz(context, attributeSet);
                this.zzccl = zztz2.zzr(bl);
                this.zzccm = zztz2.getAdUnitId();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzuo.zzof().zza(viewGroup, new zztw(context, AdSize.BANNER), illegalArgumentException.getMessage(), illegalArgumentException.getMessage());
                return;
            }
            if (viewGroup.isInEditMode()) {
                zztw zztw2;
                zzawe zzawe2 = zzuo.zzof();
                int n2 = this.zzcel;
                AdSize adSize = this.zzccl[0];
                Context context2 = context;
                if (adSize.equals(AdSize.INVALID)) {
                    zztw2 = zztw.zznz();
                } else {
                    boolean bl2;
                    zztw zztw3 = new zztw(context2, adSize);
                    new zztw(context2, adSize).zzcch = bl2 = zzwu.zzcj(n2);
                    zztw2 = zztw3;
                }
                zzawe2.zza(viewGroup, zztw2, "Ads by Google");
            }
        }
    }

    @VisibleForTesting
    private zzwu(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zztu zztu2, int n) {
        this(viewGroup, attributeSet, bl, zztu2, null, n);
    }

    public final void destroy() {
        try {
            if (this.zzcei != null) {
                this.zzcei.destroy();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final AdListener getAdListener() {
        return this.zzcbm;
    }

    public final AdSize getAdSize() {
        try {
            zztw zztw2;
            if (this.zzcei != null && (zztw2 = this.zzcei.zzjo()) != null) {
                zztw zztw3 = zztw2;
                return zzb.zza(zztw3.width, zztw3.height, zztw3.zzabd);
            }
        }
        catch (RemoteException remoteException) {
            zzawo.zze("#007 Could not call remote method.", remoteException);
        }
        if (this.zzccl != null) {
            return this.zzccl[0];
        }
        return null;
    }

    public final AdSize[] getAdSizes() {
        return this.zzccl;
    }

    public final String getAdUnitId() {
        if (this.zzccm == null && this.zzcei != null) {
            try {
                this.zzccm = this.zzcei.getAdUnitId();
            }
            catch (RemoteException remoteException) {
                zzawo.zze("#007 Could not call remote method.", remoteException);
            }
        }
        return this.zzccm;
    }

    public final AppEventListener getAppEventListener() {
        return this.zzbkg;
    }

    public final OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzcej;
    }

    public final void zza(zzws zzws2) {
        try {
            if (this.zzcei == null) {
                zzve zzve2;
                zztw zztw2;
                zzwu zzwu2 = this;
                if ((zzwu2.zzccl == null || zzwu2.zzccm == null) && zzwu2.zzcei == null) {
                    throw new IllegalStateException("The ad size and ad unit ID must be set before loadAd is called.");
                }
                zzwu zzwu3 = zzwu2;
                Context context = zzwu3.zzcek.getContext();
                Object object = zztw2 = zzwu.zza(context, zzwu3.zzccl, zzwu3.zzcel);
                if ("search_v2".equals(object.zzabd)) {
                    String string = zzwu3.zzccm;
                    zztw zztw3 = zztw2;
                    Context context2 = context;
                    object = zzuo.zzog();
                    Context context3 = context2;
                    zzve2 = (zzve)new zzug((zzuc)object, context2, zztw3, string).zzd(context3, false);
                } else {
                    zzaje zzaje2 = zzwu3.zzcee;
                    String string = zzwu3.zzccm;
                    zztw zztw4 = zztw2;
                    Context context4 = context;
                    object = zzuo.zzog();
                    Context context5 = context4;
                    zzve2 = (zzve)new zzub((zzuc)object, context4, zztw4, string, zzaje2).zzd(context5, false);
                }
                zzwu2.zzcei = zzve2;
                zzwu2.zzcei.zza(new zztl(zzwu2.zzceh));
                if (zzwu2.zzcbl != null) {
                    zzwu2.zzcei.zza(new zztk(zzwu2.zzcbl));
                }
                if (zzwu2.zzbkg != null) {
                    zzwu2.zzcei.zza(new zzty(zzwu2.zzbkg));
                }
                if (zzwu2.zzcej != null) {
                    zzwu2.zzcei.zza(new zzzs(zzwu2.zzcej));
                }
                if (zzwu2.zzbjx != null) {
                    zzwu2.zzcei.zza(new zzyc(zzwu2.zzbjx));
                }
                zzwu2.zzcei.setManualImpressionsEnabled(zzwu2.zzbke);
                zzwu zzwu4 = zzwu2;
                try {
                    IObjectWrapper iObjectWrapper = zzwu4.zzcei.zzjm();
                    if (iObjectWrapper != null) {
                        zzwu4.zzcek.addView((View)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
                    }
                }
                catch (RemoteException remoteException) {
                    zzawo.zze("#007 Could not call remote method.", remoteException);
                }
            }
            if (this.zzcei.zza(zztu.zza(this.zzcek.getContext(), zzws2))) {
                this.zzcee.zzf(zzws2.zzoy());
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void pause() {
        try {
            if (this.zzcei != null) {
                this.zzcei.pause();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void recordManualImpression() {
        if (this.zzcef.getAndSet(true)) {
            return;
        }
        try {
            if (this.zzcei != null) {
                this.zzcei.zzjn();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void resume() {
        try {
            if (this.zzcei != null) {
                this.zzcei.resume();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void setAdListener(AdListener adListener) {
        this.zzcbm = adListener;
        this.zzceh.zza(adListener);
    }

    public final void zza(zzth zzth2) {
        try {
            this.zzcbl = zzth2;
            if (this.zzcei != null) {
                this.zzcei.zza(zzth2 != null ? new zztk(zzth2) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void setAdSizes(AdSize ... adSizeArray) {
        if (this.zzccl != null) {
            throw new IllegalStateException("The ad size can only be set once on AdView.");
        }
        this.zza(adSizeArray);
    }

    public final void zza(AdSize ... adSizeArray) {
        this.zzccl = adSizeArray;
        try {
            if (this.zzcei != null) {
                this.zzcei.zza(zzwu.zza(this.zzcek.getContext(), this.zzccl, this.zzcel));
            }
        }
        catch (RemoteException remoteException) {
            zzawo.zze("#007 Could not call remote method.", remoteException);
        }
        this.zzcek.requestLayout();
    }

    public final void setAdUnitId(String string) {
        if (this.zzccm != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on AdView.");
        }
        this.zzccm = string;
    }

    public final void setAppEventListener(AppEventListener appEventListener) {
        try {
            this.zzbkg = appEventListener;
            if (this.zzcei != null) {
                this.zzcei.zza(appEventListener != null ? new zzty(appEventListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        this.zzcej = onCustomRenderedAdLoadedListener;
        try {
            if (this.zzcei != null) {
                this.zzcei.zza(onCustomRenderedAdLoadedListener != null ? new zzzs(onCustomRenderedAdLoadedListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void setManualImpressionsEnabled(boolean bl) {
        this.zzbke = bl;
        try {
            if (this.zzcei != null) {
                this.zzcei.setManualImpressionsEnabled(this.zzbke);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final String getMediationAdapterClassName() {
        try {
            if (this.zzcei != null) {
                return this.zzcei.zzjp();
            }
        }
        catch (RemoteException remoteException) {
            zzawo.zze("#007 Could not call remote method.", remoteException);
        }
        return null;
    }

    public final boolean isLoading() {
        try {
            if (this.zzcei != null) {
                return this.zzcei.isLoading();
            }
        }
        catch (RemoteException remoteException) {
            zzawo.zze("#007 Could not call remote method.", remoteException);
        }
        return false;
    }

    public final VideoController getVideoController() {
        return this.zzceg;
    }

    public final zzwk zzdd() {
        if (this.zzcei == null) {
            return null;
        }
        try {
            return this.zzcei.getVideoController();
        }
        catch (RemoteException remoteException) {
            zzawo.zze("#007 Could not call remote method.", remoteException);
            return null;
        }
    }

    public final void setVideoOptions(VideoOptions videoOptions) {
        this.zzbjx = videoOptions;
        try {
            if (this.zzcei != null) {
                this.zzcei.zza(videoOptions == null ? null : new zzyc(videoOptions));
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final VideoOptions getVideoOptions() {
        return this.zzbjx;
    }

    public final boolean zza(zzve zzve2) {
        IObjectWrapper iObjectWrapper;
        if (zzve2 == null) {
            return false;
        }
        try {
            iObjectWrapper = zzve2.zzjm();
        }
        catch (RemoteException remoteException) {
            zzawo.zze("#007 Could not call remote method.", remoteException);
            return false;
        }
        if (iObjectWrapper == null) {
            return false;
        }
        if (((View)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper)).getParent() != null) {
            return false;
        }
        this.zzcek.addView((View)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        this.zzcei = zzve2;
        return true;
    }

    private static zztw zza(Context context, AdSize[] adSizeArray, int n) {
        boolean bl;
        Object object = adSizeArray;
        int n2 = adSizeArray.length;
        for (int i = 0; i < n2; ++i) {
            if (!object[i].equals(AdSize.INVALID)) continue;
            return zztw.zznz();
        }
        object = new zztw(context, adSizeArray);
        new zztw(context, adSizeArray).zzcch = bl = zzwu.zzcj(n);
        return object;
    }

    private static boolean zzcj(int n) {
        return n == 1;
    }

    static /* synthetic */ VideoController zza(zzwu zzwu2) {
        return zzwu2.zzceg;
    }
}

