/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.RequestConfiguration;
import com.google.android.gms.ads.initialization.AdapterStatus;
import com.google.android.gms.ads.initialization.InitializationStatus;
import com.google.android.gms.ads.initialization.OnInitializationCompleteListener;
import com.google.android.gms.ads.mediation.rtb.RtbAdapter;
import com.google.android.gms.ads.reward.RewardedVideoAd;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzaex;
import com.google.android.gms.internal.ads.zzaff;
import com.google.android.gms.internal.ads.zzafi;
import com.google.android.gms.internal.ads.zzaiv;
import com.google.android.gms.internal.ads.zzaje;
import com.google.android.gms.internal.ads.zzapl;
import com.google.android.gms.internal.ads.zzapw;
import com.google.android.gms.internal.ads.zzawe;
import com.google.android.gms.internal.ads.zzawo;
import com.google.android.gms.internal.ads.zzuc;
import com.google.android.gms.internal.ads.zzuh;
import com.google.android.gms.internal.ads.zzum;
import com.google.android.gms.internal.ads.zzuo;
import com.google.android.gms.internal.ads.zzvu;
import com.google.android.gms.internal.ads.zzwx;
import com.google.android.gms.internal.ads.zzwy;
import com.google.android.gms.internal.ads.zzxa;
import com.google.android.gms.internal.ads.zzxc;
import com.google.android.gms.internal.ads.zzxe;
import com.google.android.gms.internal.ads.zzxw;
import com.google.android.gms.internal.ads.zzyt;
import java.util.HashMap;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;

public final class zzwv {
    @GuardedBy(value="lock")
    private static zzwv zzcem;
    private static final Object lock;
    private zzvu zzcen;
    private RewardedVideoAd zzceo;
    @NonNull
    private RequestConfiguration zzcep = new RequestConfiguration.Builder().build();
    private InitializationStatus zzceq;

    private zzwv() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzwv zzpd() {
        Object object = lock;
        synchronized (object) {
            if (zzcem == null) {
                zzcem = new zzwv();
            }
            return zzcem;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void zza(Context context, String string, zzxe zzxe2, OnInitializationCompleteListener onInitializationCompleteListener) {
        Object object = lock;
        synchronized (object) {
            if (this.zzcen != null) {
                return;
            }
            if (context == null) {
                throw new IllegalArgumentException("Context cannot be null.");
            }
            try {
                zzaiv.zzrj().zzc(context, string);
                Context context2 = context;
                Object object2 = zzuo.zzog();
                Context context3 = context2;
                this.zzcen = (zzvu)new zzuh((zzuc)object2, context2).zzd(context3, false);
                if (onInitializationCompleteListener != null) {
                    this.zzcen.zza(new zzxc(this, onInitializationCompleteListener, null));
                }
                this.zzcen.zza(new zzaje());
                this.zzcen.initialize();
                this.zzcen.zzb(string, ObjectWrapper.wrap((Object)new zzwy(this, context)));
                if (this.zzcep.getTagForChildDirectedTreatment() != -1 || this.zzcep.getTagForUnderAgeOfConsent() != -1) {
                    this.zza(this.zzcep);
                }
                zzyt.initialize(context);
                object2 = zzyt.zzcqp;
                if (!((Boolean)zzuo.zzoj().zzd(object2)).booleanValue()) {
                    object2 = zzyt.zzcqx;
                    if (zzuo.zzoj().zzd(object2).booleanValue()) {
                        return;
                    }
                }
                boolean bl = false;
                if (bl) return;
                if (this.zzpe()) return;
                zzawo.zzes("Google Mobile Ads SDK initialization functionality unavailable for this session. Ad requests can be made at any time.");
                object2 = this;
                this.zzceq = new zzxa((zzwv)object2);
                if (onInitializationCompleteListener == null) return;
                zzawe.zzzb.post((Runnable)new zzwx(this, onInitializationCompleteListener));
            }
            catch (RemoteException remoteException) {
                zzawo.zzd("MobileAdsSettingManager initialization failed", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final RewardedVideoAd getRewardedVideoAdInstance(Context context) {
        Object object = lock;
        synchronized (object) {
            zzaje zzaje2;
            if (this.zzceo != null) {
                return this.zzceo;
            }
            zzaje zzaje3 = zzaje2 = new zzaje();
            Context context2 = context;
            zzuc zzuc2 = zzuo.zzog();
            Context context3 = context2;
            zzapl zzapl2 = (zzapl)new zzum(zzuc2, context2, zzaje3).zzd(context3, false);
            this.zzceo = new zzapw(context, zzapl2);
            return this.zzceo;
        }
    }

    public final void setAppVolume(float f) {
        Preconditions.checkArgument((0.0f <= f && f <= 1.0f ? 1 : 0) != 0, (Object)"The app volume must be a value between 0 and 1 inclusive.");
        Preconditions.checkState((this.zzcen != null ? 1 : 0) != 0, (Object)"MobileAds.initialize() must be called prior to setting the app volume.");
        try {
            this.zzcen.setAppVolume(f);
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zzc("Unable to set app volume.", remoteException);
            return;
        }
    }

    public final float zzoo() {
        float f = 1.0f;
        if (this.zzcen == null) {
            return 1.0f;
        }
        try {
            f = this.zzcen.zzoo();
        }
        catch (RemoteException remoteException) {
            zzawo.zzc("Unable to get app volume.", remoteException);
        }
        return f;
    }

    public final void setAppMuted(boolean bl) {
        Preconditions.checkState((this.zzcen != null ? 1 : 0) != 0, (Object)"MobileAds.initialize() must be called prior to setting app muted state.");
        try {
            this.zzcen.setAppMuted(bl);
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zzc("Unable to set app mute state.", remoteException);
            return;
        }
    }

    public final boolean zzop() {
        boolean bl = false;
        if (this.zzcen == null) {
            return false;
        }
        try {
            bl = this.zzcen.zzop();
        }
        catch (RemoteException remoteException) {
            zzawo.zzc("Unable to get app mute state.", remoteException);
        }
        return bl;
    }

    public final void openDebugMenu(Context context, String string) {
        Preconditions.checkState((this.zzcen != null ? 1 : 0) != 0, (Object)"MobileAds.initialize() must be called prior to opening debug menu.");
        try {
            this.zzcen.zzc(ObjectWrapper.wrap((Object)context), string);
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zzc("Unable to open debug menu.", remoteException);
            return;
        }
    }

    public final String getVersionString() {
        Preconditions.checkState((this.zzcen != null ? 1 : 0) != 0, (Object)"MobileAds.initialize() must be called prior to getting version string.");
        try {
            return this.zzcen.getVersionString();
        }
        catch (RemoteException remoteException) {
            zzawo.zzc("Unable to get version string.", remoteException);
            return "";
        }
    }

    public final void registerRtbAdapter(Class<? extends RtbAdapter> clazz) {
        try {
            this.zzcen.zzbz(clazz.getCanonicalName());
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zzc("Unable to register RtbAdapter", remoteException);
            return;
        }
    }

    public final InitializationStatus getInitializationStatus() {
        Preconditions.checkState((this.zzcen != null ? 1 : 0) != 0, (Object)"MobileAds.initialize() must be called prior to getting initialization status.");
        try {
            if (this.zzceq != null) {
                return this.zzceq;
            }
            return zzwv.zzb(this.zzcen.zzoq());
        }
        catch (RemoteException remoteException) {
            zzawo.zzes("Unable to get Initialization status.");
            return null;
        }
    }

    private static InitializationStatus zzb(List<zzaex> list) {
        HashMap<String, AdapterStatus> hashMap = new HashMap<String, AdapterStatus>();
        for (zzaex zzaex2 : list) {
            hashMap.put(zzaex2.zzcyb, new zzaff(zzaex2.zzcyc ? AdapterStatus.State.READY : AdapterStatus.State.NOT_READY, zzaex2.description, zzaex2.zzcyd));
        }
        return new zzafi(hashMap);
    }

    @NonNull
    public final RequestConfiguration getRequestConfiguration() {
        return this.zzcep;
    }

    public final void setRequestConfiguration(@NonNull RequestConfiguration requestConfiguration) {
        Preconditions.checkArgument((requestConfiguration != null ? 1 : 0) != 0, (Object)"Null passed to setRequestConfiguration.");
        RequestConfiguration requestConfiguration2 = this.zzcep;
        this.zzcep = requestConfiguration;
        if (this.zzcen == null) {
            return;
        }
        if (requestConfiguration2.getTagForChildDirectedTreatment() != requestConfiguration.getTagForChildDirectedTreatment() || requestConfiguration2.getTagForUnderAgeOfConsent() != requestConfiguration.getTagForUnderAgeOfConsent()) {
            this.zza(requestConfiguration);
        }
    }

    private final void zza(@NonNull RequestConfiguration requestConfiguration) {
        try {
            this.zzcen.zza(new zzxw(requestConfiguration));
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zzc("Unable to set request configuration parcel.", remoteException);
            return;
        }
    }

    private final boolean zzpe() throws RemoteException {
        try {
            return this.zzcen.getVersionString().endsWith("0");
        }
        catch (RemoteException remoteException) {
            zzawo.zzes("Unable to get version string.");
            return true;
        }
    }

    final /* synthetic */ void zza(OnInitializationCompleteListener onInitializationCompleteListener) {
        onInitializationCompleteListener.onInitializationComplete(this.zzceq);
    }

    static /* synthetic */ InitializationStatus zza(zzwv zzwv2, List list) {
        return zzwv.zzb(list);
    }

    static {
        lock = new Object();
    }
}

