var questionGuess = {};
questionGuess.fn = {};

var question = {
    "Ali_Err_321999":{
        "errcode":"75193",
        "errmsg":"为什么提示「银行卡状态异常」？"
    },
    "Ali_Err_111009":{
        "errcode":"75194",
        "errmsg":"为什么提示「银行卡可用余额不足」？"
    },
    "Ali_Err_111006":{
        "errcode":"75195",
        "errmsg":"为什么提示「银行卡无法使用」？"
    },
    "T1":{
        "errcode":"75196",
        "errmsg":"卖家账户异常"
    },
    "Ali_Err_121010":{
        "errcode":"75197",
        "errmsg":"为什么提示「银行系统繁忙」？"
    },
    "Ali_Err_121036":{
        "errcode":"75198",
        "errmsg":"为什么提示「银行卡已锁定」？"
    },
    "Ali_Err_121009":{
        "errcode":"ALIN242",
        "errmsg":"为什么提示「银行卡可用余额不足」？"
    },
    "AE051990009":{
        "errcode":"75201",
        "errmsg":"为什么提示「支付失败」？"
    },
    "AE0310200163_std":{
        "errcode":"",
        "errmsg":"系统繁忙 请稍后再试"
    },
    "Ali_Err_121054":{
        "errcode":"75203",
        "errmsg":"为什么提示「交易金额超过银行限额」？"
    },
    "Ali_Err_122048":{
        "errcode":"75204",
        "errmsg":"为什么提示「银行卡登记的身份信息有误或已过期」？"
    },
    "Ali_Err_111039":{
        "errcode":"75205",
        "errmsg":"为什么提示「暂不支持此银行卡」？"
    },
    "Ali_Err_312102":{
        "errcode":"75206",
        "errmsg":"为什么提示「银行卡需要重新绑定」？"
    },
    "Ali_Err_111035":{
        "errcode":"75207",
        "errmsg":"为什么提示「银行卡已注销」？"
    },
    "Ali_Err_322005":{
        "errcode":"75208",
        "errmsg":"为什么提示「暂不支持此银行卡」？"
    },
    "Ali_Err_321029":{
        "errcode":"77141",
        "errmsg":"为什么提示「暂不支持此交易类型」？"
    },
    "Ali_Err_121015":{
        "errcode":"75209",
        "errmsg":"为什么提示「交易金额已超银行卡日最高消费金额」？"
    },
    "Ali_Err_322045":{
        "errcode":"75210",
        "errmsg":"为什么提示「银行卡未激活或未开通快捷支付功能」？"
    },
    "Ali_Err_111903":{
        "errcode":"75211",
        "errmsg":"为什么提示「交易金额已超银行卡年限额」？"
    },
    "Ali_Err_122005":{
        "errcode":"75357",
        "errmsg":"为什么提示「银行处理失败」？"
    },
    "Ali_Err_130001":{
        "errcode":"75356",
        "errmsg":"为什么提示「银行系统繁忙」？"
    },
    "T8588":{
        "errcode":"",
        "errmsg":"为什么提示「暂不支持此交易类型」？"
    },
    "Ali_Err_121006":{
        "errcode":"75212",
        "errmsg":"为什么提示「银行卡无法使用」？"
    },
    "Ali_Err_111036":{
        "errcode":"75213",
        "errmsg":"为什么提示「银行卡已冻结或已关闭快捷支付功能」？"
    },
    "Ali_Err_121057":{
        "errcode":"75355",
        "errmsg":"为什么提示「银行系统处理失败」？"
    },
    "Ali_Err_111037":{
        "errcode":"75214",
        "errmsg":"为什么提示「银行卡已挂失」？"
    },
    "Ali_Err_111901":{
        "errcode":"75215",
        "errmsg":"为什么提示「银行卡需要重新绑定」？"
    },
    "Ali_Err_111034":{
        "errcode":"75216",
        "errmsg":"为什么提示「银行卡账户信息不对，需要重新绑定」？"
    },
    "Ali_Err_121005":{
        "errcode":"75217",
        "errmsg":"为什么提示「银行卡密码校验次数超限」？"
    },
    "AE0513502027":{
        "errcode":"",
        "errmsg":"可用余额不足"
    },
    "Ali_Err_121059":{
        "errcode":"75218",
        "errmsg":"为什么提示「交易金额已超银行卡月最高消费金额」？"
    },
    "Ali_Err_322044":{
        "errcode":"75219",
        "errmsg":"为什么提示「银行卡不可用」？"
    },
    "Ali_Err_122017":{
        "errcode":"75308",
        "errmsg":"为什么提示「银行卡需要重新绑定」？"
    },
    "AE0120100006":{
        "errcode":"75220",
        "errmsg":"为什么提示「银行卡可用余额不足」？"
    },
    "Ali_Err_121064":{
        "errcode":"75221",
        "errmsg":"为什么提示「银行系统繁忙」？"
    },
    "Ali_Err_121008":{
        "errcode":"75222",
        "errmsg":"为什么提示「交易金额已超银行卡日最高消费金额」？"
    },
    "Ali_Err_322002":{
        "errcode":"75223",
        "errmsg":"为什么提示「银行账号不存在」"
    },
    "Ali_Err_121034":{
        "errcode":"75224",
        "errmsg":"为什么提示「银行账号不存在」"
    },
    "Ali_Err_111008":{
        "errcode":"75225",
        "errmsg":"为什么提示「交易金额已超银行卡日最高消费金额」？"
    },
    "ALIN39046":{
        "errcode":"75193",
        "errmsg":"为什么提示「银行卡状态异常」？"
    },
    "ALIN37768":{
        "errcode":"75194",
        "errmsg":"为什么提示「银行卡可用余额不足」？"
    },
    "ALIN38876":{
        "errcode":"75195",
        "errmsg":"为什么提示「银行卡无法使用」？"
    },
    "ALIN38910":{
        "errcode":"75197",
        "errmsg":"为什么提示「银行系统繁忙」？"
    },
    "ALIN1050":{
        "errcode":"75198",
        "errmsg":"为什么提示「银行卡已锁定」？"
    },
    "ALIN242":{
        "errcode":"75200",
        "errmsg":"为什么提示「银行卡可用余额不足」？"
    },
    "ALIN10009":{
        "errcode":"75201",
        "errmsg":"为什么提示「支付失败」？"
    },
    "ALIN38945":{
        "errcode":"75203",
        "errmsg":"为什么提示「交易金额超过银行限额」？"
    },
    "ALIN43843":{
        "errcode":"75204",
        "errmsg":"为什么提示「银行卡登记的身份信息有误或已过期」？"
    },
    "ALIN38902":{
        "errcode":"75205",
        "errmsg":"为什么提示「暂不支持此银行卡」？"
    },
    "ALIN40207":{
        "errcode":"75206",
        "errmsg":"为什么提示「银行卡需要重新绑定」？"
    },
    "ALIN38898":{
        "errcode":"75207",
        "errmsg":"为什么提示「银行卡已注销」？"
    },
    "ALIN39051":{
        "errcode":"75208",
        "errmsg":"为什么提示「暂不支持此银行卡」？"
    },
    "ALIN39032":{
        "errcode":"77141",
        "errmsg":"为什么提示「暂不支持此交易类型」？"
    },
    "ALIN38915":{
        "errcode":"75209",
        "errmsg":"为什么提示「交易金额已超银行卡日最高消费金额」？"
    },
    "ALIN39060":{
        "errcode":"75210",
        "errmsg":"为什么提示「银行卡未激活或未开通快捷支付功能」？"
    },
    "ALIN41253":{
        "errcode":"75211",
        "errmsg":"为什么提示「交易金额已超银行卡年限额」？"
    },
    "ALIN38974":{
        "errcode":"75357",
        "errmsg":"为什么提示「银行处理失败」？"
    },
    "ALIN4854":{
        "errcode":"75356",
        "errmsg":"为什么提示「银行系统繁忙」？"
    },
    "ALIN38906":{
        "errcode":"75212",
        "errmsg":"为什么提示「银行卡无法使用」？"
    },
    "ALIN38899":{
        "errcode":"75213",
        "errmsg":"为什么提示「银行卡已冻结或已关闭快捷支付功能」？"
    },
    "ALIN1140":{
        "errcode":"75355",
        "errmsg":"为什么提示「银行系统处理失败」？"
    },
    "ALIN38900":{
        "errcode":"75214",
        "errmsg":"为什么提示「银行卡已挂失」？"
    },
    "ALIN41250":{
        "errcode":"75215",
        "errmsg":"为什么提示「银行卡需要重新绑定」？"
    },
    "ALIN38897":{
        "errcode":"75216",
        "errmsg":"为什么提示「银行卡账户信息不对，需要重新绑定」？"
    },
    "ALIN38905":{
        "errcode":"75217",
        "errmsg":"为什么提示「银行卡密码校验次数超限」？"
    },
    "ALIN42498":{
        "errcode":"",
        "errmsg":"为什么提示「可用余额不足」？"
    },
    "ALIN38950":{
        "errcode":"75218",
        "errmsg":"为什么提示「交易金额已超银行卡月最高消费金额」？"
    },
    "ALIN39059":{
        "errcode":"75219",
        "errmsg":"为什么提示「银行卡不可用」？"
    },
    "ALIN38986":{
        "errcode":"75308",
        "errmsg":"为什么提示「银行卡需要重新绑定」？"
    },
    "ALIN39500":{
        "errcode":"75220",
        "errmsg":"为什么提示「银行卡可用余额不足」？"
    },
    "ALIN39395":{
        "errcode":"75221",
        "errmsg":"为什么提示「银行系统繁忙」？"
    },
    "ALIN38909":{
        "errcode":"75222",
        "errmsg":"为什么提示「交易金额已超银行卡日最高消费金额」？"
    },
    "ALIN39048":{
        "errcode":"75223",
        "errmsg":"为什么提示「银行账号不存在」"
    },
    "ALIN38930":{
        "errcode":"75224",
        "errmsg":"为什么提示「银行账户不存在」"
    },
    "ALIN211":{
        "errcode":"75225",
        "errmsg":"为什么提示「交易金额已超银行卡日最高消费金额」？"
    }
}

questionGuess.fn.makeGuess = function (pageName, pageData) {

    if (pageName === 'QUICKPAY@cashier-channel-logo-flex') {
       return guessOnChannelogoFlex(pageData)
    }
}

function guessOnChannelogoFlex(rpc) {

    data = rpc.payments;
    error = rpc.err;
    bizErrCode = rpc.bizErrorCode;

    var sharepaystatus = "-";
    var honeypaystatus = "-";
    var balancestatus = "-";
    var monyfundstatus = "-";
    var alicreditstatus = "-";
    var alicreditfqgstatus = "-";

    var honeypayleft = "-";
    var balanceleft = "-";
    var monyfundleft = "-";
    var alicreditleft = "-";
    var alicreditfqgleft = "-";

    var dcCard = 0;
    var dcCardDisable = 0;

    var dcCardNotSupport = 0;
    var dcCardNotSupportArr = new Array();
    var dcCardNotEnough = 0;
    var dcCardNotEnoughArr = new Array();

    var dcCardPayLimit = 0;
    var dcCardPayLimitArr = new Array();

    var dcCardDayLimit = 0;
    var dcCardDayLimitArr = new Array();

    var dcCardMonthLimit = 0;
    var dcCardMonthLimitArr = new Array();

    var dcCardMaintain = 0;
    var dcCardMaintainArr = new Array();


    var ccCard = 0;
    var ccCardDisable = 0;

    var ccCardNotSupport = 0;
    var ccCardNotSupportArr = new Array();

    var ccCardNotEnough = 0;
    var ccCardNotEnoughArr = new Array();

    var ccCardMaintain = 0;
    var ccCardMaintainArr = new Array();

    var otherCard = 0;
    var otherCardDisable = 0;
    var otherCardNotSupport = 0;
    var otherCardNotEnough = 0;
    var otherCardMaintain = 0;

    var pageErrcode = '-';
    var pageErrmsg = '-';

    if (Object.prototype.toString.call(data) !== '[object Array]') {
        return;
    }

    if (typeof(error) == 'string' && error.length > 0) {
        var matched = new Array();
        var pattern = new RegExp('.*\\((.+)\\)')
        var matched  = pattern.exec(error);
        if (matched && matched.length > 1) {
            pageErrmsg = matched[0];
            pageErrcode = matched[1];
        }

        if (pageErrmsg.length > 1 && pageErrmsg.indexOf('<font') > 0) {
            pageErrmsg = pageErrmsg.substring(0, pageErrmsg.indexOf('<font'));
        }
    }

    if (bizErrCode && bizErrCode.length > 0) {
        pageErrcode = bizErrCode;
    }

    for (var i = 0; i < data.length; i++) {

        var channel = data[i];
        if (channel != null) {
            var spmObj = channel["spmObj"];
            if (spmObj != null) {
                var channelType = spmObj["channelType"];

                // 代付
                if (channelType === 'SP') {
                    sharepaystatus = 'a';
                }

                // 亲密付
                else if (channelType === 'HONEYPAY') {
                    honeypaystatus = 'a';
                    if (channel.hasOwnProperty("disable") && channel.disable) {
                        honeypaystatus = '0';
                    }

                    var detail = channel.detail;
                    if (detail != null) {
                        var matched = new Array();
                        var pattern = new RegExp('(\\d+\\.\\d+)', 'g')
                        var result;
                        do {
                            result = pattern.exec(detail);
                            matched.push(result);
                        }
                        while (result != null)

                        if (matched.length >= 2) {
                            honeypayleft = matched[1];
                        } else if (matched.length == 1) {
                            honeypayleft = '-';
                        }

                        if (detail.indexOf("不支持") > 0) {
                            honeypaystatus = '1';
                        } else if (detail.indexOf('不足') > 0) {
                            honeypaystatus = '2';
                        }
                    }
                }

                // 账户余额
                else if (channelType === 'B') {
                    balancestatus = 'a';
                    var value = channel["value"];
                    if (value != null && value.length > 20) {
                        uid = value.substring(value.indexOf('B:') + 2, value.indexOf('B:') + 18);
                    }

                    if (value.indexOf('disable') > 0 && value.indexOf('disable') > 0) {
                        balancestatus = "0";
                    }

                    var tail = channel["tail"];
                    if (tail && tail.length > 0) {
                        var matched = new Array();
                        var pattern = new RegExp('(\\d+\\.\\d+)', 'g')
                        var result;
                        do {
                            result = pattern.exec(detail);
                            matched.push(result);
                        }
                        while (result != null)

                        if (matched.length >= 2) {
                            balanceleft = matched[1];
                        } else if (matched.length == 1) {
                            balanceleft = '-';
                        }
                    }

                    var detail = channel["detail"]
                    if (detail && detail.length > 0) {
                        if (detail.indexOf('不支持') > 0) {
                            balancestatus = '1';
                        } else if (detail.indexOf('不足') > 0) {
                            balancestatus = '2';
                        } else if (detail.indexOf('身份信息') > 0) {
                            balancestatus = '3';
                        } else if (detail.indexOf('网商银行') > 0 || detail.indexOf('网商银行') > 0) {
                            balancestatus = '4';
                        } else if (detail.indexOf('16周') > 0) {
                            balancestatus = '5';
                        } else if (detail.indexOf('上限') > 0) {
                            balancestatus = '6';
                        }
                    }
                } else if (channelType === 'MF') {
                    monyfundstatus = 'a';
                    if (channel.hasOwnProperty('disable') && channel["disable"]) {
                        monyfundstatus = '0';
                    }

                    var tail = channel['tail'];
                    if (tail && tail.length > 0) {
                        var matched = new Array();
                        var pattern = new RegExp('(\\d+\\.\\d+)', 'g')
                        var result;
                        do {
                            result = pattern.exec(detail);
                            matched.push(result);
                        }
                        while (result != null)

                        if (matched.length >= 2) {
                            monyfundleft = matched[1];
                        } else if (matched.length == 1) {
                            monyfundleft = '-';
                        }
                    }

                    var detail = channel['detail'];
                    if (detail && detail.length > 0) {
                        if (detail.indexOf('不支持') > 0) {
                            monyfundstatus = '1';
                        } else if (detail.indexOf('不足') > 0) {
                            monyfundstatus = '2';
                        }
                    }
                } else if (channelType === 'ALICREDIT') {
                    alicreditstatus = 'a';
                    if (channel.hasOwnProperty('disable') && channel['disable']) {
                        alicreditstatus = '0';
                    }

                    var detail = channel['detail'];
                    if (detail && detail.length > 0) {
                        var matched = new Array();
                        var pattern = new RegExp('(\\d+\\.\\d+)', 'g')
                        var result;
                        do {
                            result = pattern.exec(detail);
                            matched.push(result);
                        }
                        while (result != null)

                        if (matched.length >= 2) {
                            alicreditleft = matched[1];
                        } else if (matched.length == 1) {
                            alicreditleft = '-';
                        }

                        if (detail.indexOf('不支持') > 0) {
                            alicreditstatus = '1';
                        } else if (detail.indexOf('不足') > 0) {
                            alicreditstatus = '2';
                        } else if (detail.indexOf('先消费') > 0 || detail.indexOf('先消費') > 0) {
                            alicreditstatus = 'ar';
                        }
                    }
                } else if (channelType === 'ALICREDITFQG') {
                    alicreditfqgstatus = 'a';
                    if (channel.hasOwnProperty('disable') && channel['disable']) {
                        alicreditfqgstatus = '0';
                    }

                    var detail = channel['detail'];
                    if (detail && detail.length > 0) {
                        var matched = new Array();
                        var pattern = new RegExp('(\\d+\\.\\d+)', 'g')
                        var result;
                        do {
                            result = pattern.exec(detail);
                            matched.push(result);
                        }
                        while (result != null)

                        if (matched.length >= 2) {
                            alicreditfqgleft = matched[1];
                        } else if (matched.length == 1) {
                            alicreditfqgleft = '-';
                        }

                        if (detail.indexOf('不支持') > 0) {
                            alicreditfqgstatus = '1';
                        } else if (detail.indexOf('不足') > 0) {
                            alicreditfqgstatus = '2';
                        } else if (detail.indexOf('先消费') > 0 || detail.indexOf('先消費') > 0) {
                            alicreditfqgstatus = 'ar';
                        }
                    }
                } else if (channelType === 'EXPRESS_DC') {
                    dcCard++;
                    if (channel.hasOwnProperty('disable') && channel['disable']) {
                        dcCardDisable++;

                        var name = channel['name'] + channel['tail'];
                        var detail = channel['detail'];

                        if (detail && detail.length > 0) {
                            if (detail.indexOf('不支持') > 0) {
                                dcCardNotSupport++;
                                dcCardNotSupportArr.push(name);
                            } else if (detail.indexOf('不足') > 0) {
                                dcCardNotEnough++;
                                dcCardNotEnoughArr.push(name);
                            } else if (detail.indexOf('笔限额') > 0 || detail.indexOf('筆限額') > 0) {
                                dcCardPayLimit++;
                                dcCardPayLimitArr.push(name);
                            } else if (detail.indexOf('日限额') > 0 || detail.indexOf('日限額') > 0) {
                                dcCardDayLimit++;
                                dcCardDayLimitArr.push(name);
                            } else if (detail.indexOf('月限额') > 0 || detail.indexOf('月限額') > 0) {
                                dcCardMonthLimit++;
                                dcCardMonthLimitArr.push(name);
                            } else if (detail.indexOf('维护') > 0 || detail.indexOf('維護') > 0) {
                                dcCardMaintain++;
                                dcCardMaintainArr.push(name);
                            }
                        }
                    }


                } else if (channelType === 'EXPRESS_CC' || channelType === 'CARTOON_CC') {
                    ccCard++;
                    if (channel.hasOwnProperty('disable') && channel['disable']) {
                        ccCardDisable++;

                        var name = channel['name'] + channel['tail'];
                        var detail = channel['detail'];
                        if (detail && detail.length > 0) {
                            if (detail.indexOf('不支持') > 0) {
                                ccCardNotSupport++;
                                ccCardNotSupportArr.push(name);
                            } else if (detail.indexOf('不足') > 0) {
                                ccCardNotEnough++;
                                ccCardNotEnoughArr.push(name);
                            } else if (detail.indexOf('维护') > 0 || detail.indexOf('維護') > 0) {
                                ccCardMaintain++;
                                ccCardMaintainArr.push(name);
                            }
                        }
                    }
                } else if (channelType !== 'newCard' && channelType !== 'pollingPay') {
                    otherCard++;
                    if (channel.hasOwnProperty('disable') && channel['disable']) {
                        otherCardDisable++;
                    }

                    var detail = channel['detail'];
                    if (detail && detail.length > 0) {
                        if (detail.indexOf('不支持') > 0) {
                            otherCardNotSupport++;
                        } else if (detail.indexOf('不足') > 0) {
                            otherCardNotEnough++;
                        } else if (detail.indexOf('维护') > 0 || detail.indexOf('維護') > 0) {
                            otherCardMaintain++;
                        }
                    }
                }
            }
        }
    }

    var strRet = uid; // 1 uid
    strRet = strRet + "," + sharepaystatus; // 2 代付

    strRet = strRet + "," + honeypaystatus; // 3 亲密付
    strRet = strRet + "," + honeypayleft; // 4 亲密付信息

    strRet = strRet + "," + balancestatus; // 5 余额
    strRet = strRet + "," + balanceleft; // 6 余额信息

    strRet = strRet + "," + monyfundstatus; // 7 余额宝
    strRet = strRet + "," + monyfundleft; // 8 余额宝信息

    strRet = strRet + "," + alicreditstatus; // 9 花呗
    strRet = strRet + "," + alicreditleft; // 10

    strRet = strRet + "," + alicreditfqgstatus; // 11 花呗分期
    strRet = strRet + "," + alicreditfqgleft; // 12

    strRet = strRet + "," + dcCard; // 13 储蓄卡
    strRet = strRet + "," + dcCardDisable; // 14
    strRet = strRet + "," + dcCardNotSupport; // 15
    strRet = strRet + "," + dcCardNotEnough; // 16
    strRet = strRet + "," + dcCardPayLimit; // 17
    strRet = strRet + "," + dcCardDayLimit; // 18
    strRet = strRet + "," + dcCardMonthLimit; // 19
    strRet = strRet + "," + dcCardMaintain; // 20

    strRet = strRet + "," + ccCard; // 21 信用卡
    strRet = strRet + "," + ccCardDisable; // 22
    strRet = strRet + "," + ccCardNotSupport; // 23
    strRet = strRet + "," + ccCardNotEnough; // 24
    strRet = strRet + "," + ccCardMaintain; // 25

    strRet = strRet + "," + otherCard; // 26
    strRet = strRet + "," + otherCardDisable; // 27
    strRet = strRet + "," + otherCardNotSupport; // 28
    strRet = strRet + "," + otherCardNotEnough; // 29
    strRet = strRet + "," + otherCardMaintain; // 30

    // 拼装errorInfo
    var guessArr = new Array();

    // 花呗不可用
    if (alicreditstatus === '-') {
        alicreditError = new Object();
        alicreditError.errcode = '167';
        alicreditError.errmsg = '为什么「花呗」不能用？';
        alicreditError.needcheck = 'Y';

        if (alicreditError.hasOwnProperty('errcode') && alicreditError.errcode.length > 0) {
            guessArr.push(alicreditError);
        }
    }

    if (alicreditstatus !== 'a' && alicreditstatus !== '-') {

        alicreditError = new Object();

        if (alicreditstatus === '1') {
            // 不支持
            alicreditError.errcode = '167';
            alicreditError.errmsg = '为什么「花呗」不能用？';
        } else if (alicreditstatus === '2') {
            // 不足
            alicreditError.errcode = '167';
            alicreditError.errmsg = '为什么「花呗」不能用？';
        } else if (alicreditstatus === 'ar') {
            // 先消费
            alicreditError.errcode = '167';
            alicreditError.errmsg = '为什么「花呗」不能用？';
        } else {
            alicreditError.errcode = '167';
            alicreditError.errmsg = '为什么「花呗」不能用？';
        }

        if (alicreditError.hasOwnProperty('errcode') && alicreditError.errcode.length > 0) {
            guessArr.push(alicreditError);
        }
    }

    if (pageErrcode !== '-') {
        var pageError = question[pageErrcode]
        if (pageError) {
            guessArr.push(pageError);
        }
    }

    // 余额不可用
    if (balancestatus !== 'a' && balancestatus !== '-') {

        var balanceError = new Object();

        if (balancestatus === '1') {
            // 不支持
            balanceError.errcode = '75307';
            balanceError.errmsg = '为什么「账户余额」不能用？';
        } else if (balancestatus === '2') {
            // 不足
            balanceError.errcode = '75303';
            balanceError.errmsg = '为什么「账户余额」提示金额不足？';
        } else if (balancestatus === '3') {
            // 身份信息
            balanceError.errcode = '75304';
            balanceError.errmsg = '为什么「账户余额」提示需要完善身份信息？';
        } else if (balancestatus === '4') {
            // 网商银行
            balanceError.errcode = '';
            balanceError.errmsg = '';
        } else if (balancestatus === '5') {
            // 16周岁
            balanceError.errcode = '75306';
            balanceError.errmsg = '为什么「账户余额」提示支付额度受限制？';
        } else if (balancestatus === '6') {
            // 上限
            balanceError.errcode = '75305';
            balanceError.errmsg = '为什么「账户余额」提示支付额度受限制？';
        } else {
            balanceError.errcode = '';
            balanceError.errmsg = '';
        }

        if (balanceError.hasOwnProperty('errcode') && balanceError.errcode.length > 0) {
            guessArr.push(balanceError);
        }
    }

    // 余额宝不可用 
    if (monyfundstatus === '-') {
        monyfundError = new Object();
        monyfundError.errcode = '26791';
        monyfundError.errmsg = '为什么「余额宝」不能用？';
        monyfundError.needcheck = 'Y';

        if (monyfundError.hasOwnProperty('errcode') && monyfundError.errcode.length > 0) {
            guessArr.push(monyfundError);
        }
    }
    
    if (monyfundstatus !== 'a' && monyfundstatus !== '-') {

        monyfundError = new Object();

        if (monyfundstatus === '1') {
            // 不支持
            monyfundError.errcode = '';
            monyfundError.errmsg = '余额宝不支持';

        } else if (monyfundstatus === '2') {
            // 不足
            monyfundError.errcode = '';
            monyfundError.errmsg = '余额宝额度不足';
        } else {
            monyfundError.errcode = '';
            monyfundError.errmsg = '余额宝未知错误';
        }

        if (monyfundError.hasOwnProperty('errcode') && monyfundError.errcode.length > 0) {
            guessArr.push(monyfundError);
        }
    }

    // 储蓄卡不可用

    // 储蓄卡不支持
    for (var i = 0; i < dcCardNotSupportArr.length; i++) {
        dcCardNotSupportError = new Object();
        dcCardNotSupportError.errcode = '75205';
        dcCardNotSupportError.errmsg =  dcCardNotSupportArr[i] + '提示不支持？';

        if (dcCardNotSupportError.hasOwnProperty('errcode') && dcCardNotSupportError.errcode.length > 0) {
            guessArr.push(dcCardNotSupportError);
        }
    }

    // 储蓄卡余额不足
    for (var i = 0; i < dcCardNotEnoughArr.length; i++) {
        dcCardNotEnoughErr = new Object();
        dcCardNotEnoughErr.errcode = '75194';
        dcCardNotEnoughErr.errmsg = dcCardNotEnoughArr[i] + '提示余额不足 ？';

        if (dcCardNotEnoughErr.hasOwnProperty('errcode') && dcCardNotEnoughErr.errcode.length > 0) {
            guessArr.push(dcCardNotEnoughErr);
        }
    }

    // 储蓄卡单笔限额
    for (var i = 0; i < dcCardPayLimitArr.length; i++) {
        dcCardPayLimitErr = new Object();
        dcCardPayLimitErr.errcode = '75203';
        dcCardPayLimitErr.errmsg = dcCardPayLimitArr[i] + '提示单笔限额 ？';

        if (dcCardPayLimitErr.hasOwnProperty('errcode') && dcCardPayLimitErr.errcode.length > 0) {
            guessArr.push(dcCardPayLimitErr);
        }
    }

    // 储蓄卡单日限额
    for (var i = 0; i < dcCardDayLimitArr.length; i++) {
        dcCardDayLimitErr = new Object();
        dcCardDayLimitErr.errcode = '75209';
        dcCardDayLimitErr.errmsg = dcCardDayLimitArr[i] + '提示单日限额 ？';

        if (dcCardDayLimitErr.hasOwnProperty('errcode') && dcCardDayLimitErr.errcode.length > 0) {
            guessArr.push(dcCardDayLimitErr);
        }
    }

    // 储蓄卡月限额
    for (var i = 0; i < dcCardMonthLimitArr.length; i++) {
        dcCardMonthLimitErr = new Object();
        dcCardMonthLimitErr.errcode = '75218';
        dcCardMonthLimitErr.errmsg = dcCardMonthLimitArr[i] + '提示月限额 ？';

        if (dcCardMonthLimitErr.hasOwnProperty('errcode') && dcCardMonthLimitErr.errcode.length > 0) {
            guessArr.push(dcCardMonthLimitErr);
        }
    }

    // 储蓄卡系统维护中
    for (var i = 0; i < dcCardMaintainArr.length; i++) {
        dcCardMaintainErr = new Object();
        dcCardMaintainErr.errcode = '75356';
        dcCardMaintainErr.errmsg = dcCardMaintainArr[i] + '提示系统维护 ？';

        if (dcCardMaintainErr.hasOwnProperty('errcode') && dcCardMaintainErr.errcode.length > 0) {
            guessArr.push(dcCardMaintainErr);
        }
    }

    // 信用卡不可用
    for (var i = 0; i < ccCardNotSupportArr.length; i++) {
        ccCardNotSupportErr = new Object();
        ccCardNotSupportErr.errcode = '75205';
        ccCardNotSupportErr.errmsg =  ccCardNotSupportArr[i] + '提示不支持 ？';

        if (ccCardNotSupportErr.hasOwnProperty('errcode') && ccCardNotSupportErr.errcode.length > 0) {
            guessArr.push(ccCardNotSupportErr);
        }
    }

    // 信用卡不足
    for (var i = 0; i < ccCardNotEnoughArr.length; i++) {
        ccCardNotSupportErr = new Object();
        ccCardNotSupportErr.errcode = '';
        ccCardNotSupportErr.errmsg = ccCardNotEnoughArr[i] + '提示额度不足';

        if (ccCardNotSupportErr.hasOwnProperty('errcode') && ccCardNotSupportErr.errcode.length > 0) {
            guessArr.push(ccCardNotSupportErr);
        }
    }

    // 信用卡维护
    for (var i = 0; i < ccCardMaintainArr.length; i++) {
        ccCardMaintainErr = new Object();
        ccCardMaintainErr.errcode = '75356';
        ccCardMaintainErr.errmsg =  ccCardMaintainArr[i] + '提示系统维护 ？';

        if (ccCardMaintainErr.hasOwnProperty('errcode') && ccCardMaintainErr.errcode.length > 0) {
            guessArr.push(ccCardMaintainErr);
        }
    }
    
    // 花呗分期不可用
    if (alicreditfqgstatus === '-') {
        alicreditfqgError = new Object();
        alicreditfqgError.errcode = '186';
        alicreditfqgError.errmsg = '为什么「花呗分期」不能用？';
        alicreditfqgError.needcheck = 'Y';

        if (alicreditfqgError.hasOwnProperty('errcode') && alicreditfqgError.errcode.length > 0) {
            guessArr.push(alicreditfqgError);
        }
    }

    if (alicreditfqgstatus !== 'a' && alicreditfqgstatus !== '-') {

        alicreditfqgError = new Object();

        if (alicreditfqgstatus === '1') {
            alicreditfqgError.errcode = '186';
            alicreditfqgError.errmsg = '为什么「花呗分期」不能用？';
        } else if (alicreditfqgstatus === '2') {
            alicreditfqgError.errcode = '186';
            alicreditfqgError.errmsg = '为什么「花呗分期」不能用？';
        } else if (alicreditfqgstatus === 'ar') {
            alicreditfqgError.errcode = '186';
            alicreditfqgError.errmsg = '为什么「花呗分期」不能用？';
        } else {
            alicreditfqgError.errcode = '186';
            alicreditfqgError.errmsg = '为什么「花呗分期」不能用？';
        }

        if (alicreditfqgError.hasOwnProperty('errcode') && alicreditfqgError.errcode.length > 0) {
            guessArr.push(alicreditfqgError);
        }
    }

        // 代付不可用
    if (sharepaystatus !== 'a') {

        var sharepayError = new Object();
        sharepayError.errcode = '5615';
        sharepayError.errmsg = '为什么「代付」不能用？';
        sharepayError.needcheck = 'Y';
        guessArr.push(sharepayError);
    }

    // 亲密付不可用
    if (honeypaystatus === '-') {
        honeypayError = new Object();
        honeypayError.errcode = '7381';
        honeypayError.errmsg = '为什么「亲密付」不能用？';
        honeypayError.needcheck = 'Y';
        if (honeypayError.hasOwnProperty('errcode') && honeypayError.errcode.length > 0) {
            guessArr.push(honeypayError);
        }
    }

    if (honeypaystatus !== 'a' && honeypaystatus !== '-') {

        honeypayError = new Object();

        if (honeypaystatus === '1') {
            // 不支持
            honeypayError.errcode = '';
            honeypayError.errmsg = '';

        } else if (honeypaystatus === '2') {
            // 不足
            honeypayError.errcode = '';
            honeypayError.errmsg = '';
        } else {
            honeypayError.errcode = '';
            honeypayError.errmsg = '';
        }

        if (honeypayError.hasOwnProperty('errcode') && honeypayError.errcode.length > 0) {
            guessArr.push(honeypayError);
        }
    }
    return guessArr;
};



