package com.taobao.interact.mediaplayer.service;
import com.taobao.interact.mediaplayer.service.OnCompletionListener;
import com.taobao.interact.mediaplayer.service.OnErrorListener;
import com.taobao.interact.mediaplayer.service.OnPreparedListener;

interface IMediaPlayerService {
	void play(String path, String id);
	void playWithUrl(String url, String id);
	void resume(String id);
	void pause(String id);
	boolean isPausing(String id);
	void stop(String id);
	void release(String id);
	boolean isPlaying(String id);
	void setLooping(boolean looping, String id);
	void setVolume(float leftVolume, float rightVolume, String id);
	void reset(String id);
	int getCurrentPosition(String id);
	int getDuration(String id);
	void setOnCompletionListener(OnCompletionListener onCompletionListener, String id);
	void setOnErrorListener(OnErrorListener onErrorListener, String id);
	void setOnPreparedListener(OnPreparedListener onPreparedListener, String id);
}
