package com.taobao.interact.mediaplayer.service;


interface OnErrorListener {
	 /**
     * Called to indicate an error.
     *
     * @param identifier      the MediaPlayer id
     * @param what    the type of error that has occurred:
     * <ul>
     * <li>{@link #MEDIA_ERROR_UNKNOWN}
     * <li>{@link #MEDIA_ERROR_SERVER_DIED}
     * </ul>
     * @param extra an extra code, specific to the error. Typically
     * implementation dependent.
     * <ul>
     * <li>{@link #MEDIA_ERROR_IO}
     * <li>{@link #MEDIA_ERROR_MALFORMED}
     * <li>{@link #MEDIA_ERROR_UNSUPPORTED}
     * <li>{@link #MEDIA_ERROR_TIMED_OUT}
     * </ul>
     * @return True if the method handled the error, false if it didn't.
     * Returning false, or not having an OnErrorListener at all, will
     * cause the OnCompletionListener to be called.
     */
	boolean onError(String identifier, int what, int extra);
}
