package com.taobao.interact.upload.service;


interface FileUploadBaseListener {
	/**
	 * 文件开始上传的回调
	 */
	void onStart();

	/**
	 * 上传文件的进度回调
	 
	 * @param bytesWritten 上传字节数
	 * @param bytesTotal 文件总字节数
	 * 
	 */
	void onProgress(long bytesWritten, long bytesTotal);

	/**
	 * 文件上传成功回调
	 * @param localPath 文件本地路径
	 * @param url 文件url
	 */
	void onFinish(String localPath, String url);

	/**
	 * 文件上传错误回调
	 * 
	 * @param errType 错误类型
	 * @param errCode 错误码
	 * @param errMsg 错误消息
	 */
	void onError(String errType, String errCode, String errMsg);

}
