package com.taobao.interact.upload.service;

import java.util.List;

interface UploadCallBack {
	
	/**
	 * 上传文件开始回调
	 */
	void onStart();
	
	/**
	 * 上传文件的进度回调
	 
	 * @param bytesWritten 上传字节数
	 * @param bytesTotal 文件总字节数
	 * 
	 */
	void onProgress(long bytesWritten, long bytesTotal);
	
	/**
	 * 文件上传成功的回调
	 * @param loaclFiles 本地文件路径集合
	 * @param urls  上传文件的url集合
	 * @throws android.os.RemoteException
	 */
	void onFinish(in List<String> loaclFiles, in List<String> urls);
	
	/**
	 * 文件上传错误的回调
	 * @param errCode 错误码
	 * @param errMsg  错误信息
	 * @param errFiles 错误文件本地集合
	 * @throws android.os.RemoteException
	 */
	void onError(String errCode, String errMsg, in List<String> errFiles);

}
