#version 300 es

layout(location = 0) in vec3 position;
layout(location = 1) in vec4 color;
layout(location = 2) in vec2 uv;

out vec4 fragmentColor;
out vec2 textureCoord;

uniform mat4 projection;
uniform mat4 view;
uniform mat4 model;

void main() {
    fragmentColor = color;
    textureCoord = uv;
    gl_Position = projection * view * model * vec4(position, 1);
}
