#version 300 es

precision mediump float;

in vec4 fragmentColor;
in vec2 textureCoord;

out vec4 fragColor;

uniform sampler2D diffuseTexture;
uniform int useColorFilter;
uniform ivec3 filterColor;

void main() {
    vec4 textureColor = texture(diffuseTexture, textureCoord);
    if (textureColor.a < 0.01f || fragmentColor.a < 0.01f)
        discard;
    if (useColorFilter == 1) {
        int textureRed = int(textureColor.r * 255.0f);
        int textureGreen = int(textureColor.g * 255.0f);
        int textureBlue = int(textureColor.b * 255.0f);
        if (textureRed == filterColor.r && textureGreen == filterColor.g && textureBlue == filterColor.b) {
            fragColor = vec4(0);
        } else {
            fragColor = fragmentColor * textureColor;
        }
    } else {
        fragColor = fragmentColor * textureColor;
    }
}
