/*
 * =====================================================================================
 *
 *       Filename:  recognize_response_handler.h
 *
 *    Description:  recognize response handler
 *
 *        Version:  1.0
 *        Created:  2021/1/21
 *       Revision:  none
 *       Compiler:  gcc
 *
 *         Author:  jack.kj@alibaba-inc.com
 *
 * =====================================================================================
 */
#ifndef GAEA_AI_GAEA_ASR_SPEECH_RECOGNIZE_RESPONSE_HANDLER_H_
#define GAEA_AI_GAEA_ASR_SPEECH_RECOGNIZE_RESPONSE_HANDLER_H_

#include <memory>
#include <string>

#include "gaea/asr/speech_recognize_response.h"

namespace gaea {
namespace asr {

class SpeechRecognizeResponseHandler {
 protected:
  SpeechRecognizeResponseHandler() = default;
  virtual ~ SpeechRecognizeResponseHandler() = default;

 public:
  // when some result backs, it will callback OnResponse
  virtual void OnResponse(const SpeechRecognizeResponse& response) = 0;

  // if all recognize complete, it will callback this
  virtual void OnComplete(const SpeechRecognizeResponse& response) = 0;

  // if error occurs, OnResponse and OnComplete will no longer callback
  virtual void OnError(const std::string& error_message) = 0;
};

typedef std::shared_ptr<SpeechRecognizeResponseHandler> SpeechRecognizeResponseHandlerPtr;

} // namespace asr
} // namespace gaea

#endif 
