﻿//
//  base64_url.hpp
//  GaeaBase
//
//  Created by Herb on 2019/6/4.
//  Copyright © 2019年 DingTalk. All rights reserved.
//

#ifndef GAEA_BASE_BASE64_URL_H_
#define GAEA_BASE_BASE64_URL_H_

#include <string>

#include "gaea/base/macros.h"

namespace gaea {
namespace base {

enum Base64UrlEncodePolicy {
  // Include the trailing padding in the output, when necessary.
  kIncludePadding,
  // Remove the trailing padding from the output.
  kOmitPadding
};

enum Base64UrlDecodePolicy {
  // Require inputs contain trailing padding if non-aligned.
  kRequirePadding,
  // Accept inputs regardless of whether or not they have the correct padding.
  kIgnorePadding,
  // Reject inputs if they contain any trailing padding.
  kDisallowPadding
};

class Base64Url {
 public:
  static std::string Encode(const std::string& input,
                            Base64UrlEncodePolicy policy);
                              
  static bool Decode(const std::string& input,
                     Base64UrlDecodePolicy policy,
                     std::string* output);
};

} // end of namespace base
} // end of namespace gaea

#endif /* GAEA_BASE_BASE64_URL_H_ */
