//
//  DateTime.hpp
//  Atlas
//
//  Created by jinxi on 4/25/16.
//  Copyright © 2016 jinxi. All rights reserved.
//

#ifndef GAEA_BASE_DATATIME_H_
#define GAEA_BASE_DATATIME_H_

#include <chrono>
#include <cstdint>

#include "gaea/base/macros.h"

namespace gaea {
namespace base {

class DateTime {
public:
  static int64_t CurrentSeconds(void);
  static int64_t CurrentMillis(void);
  static int64_t TimeSinceEpoch(const std::chrono::steady_clock::time_point& time_point);

  static std::chrono::time_point<std::chrono::steady_clock> Now();
  static int64_t CurrentSteadyClockMillis(void);
};

}
}

#endif /* GAEA_BASE_DATATIME_H_ */
