﻿//
//  ErrorResultException.hpp
//  Atlas
//
//  Created by jinxi on 7/20/16.
//  Copyright © 2016 jinxi. All rights reserved.
//

#ifndef GAEA_BASE_ERROR_RESULT_EXCEPTION_H_
#define GAEA_BASE_ERROR_RESULT_EXCEPTION_H_

#include <stdexcept>

#include "gaea/base/error_result.h"
#include "gaea/base/macros.h"

namespace gaea {
namespace base {
  
class ErrorResultException;
class ErrorResultException : public std::runtime_error {
 public:
  ErrorResultException(const ErrorResult& error);
  ~ErrorResultException();

 public:
  ErrorResultException() : std::runtime_error("") {}

 public:
  const ErrorResult& error() const { return error_; }

 public:
 //  static std::exception_ptr MakeExceptionPtr(const gaea::base::ErrorResult& error);

 private:
  ErrorResult error_;
};

} // end of namespace base
} // end of namespace gaea

#endif /* GAEA_BASE_ERROR_RESULT_EXCEPTION_H_ */
