//
//  File.hpp
//  Atlas
//
//  Created by jinxi on 4/21/16.
//  Copyright © 2016 jinxi. All rights reserved.
//

#ifndef GAEA_BASE_FILE_H_
#define GAEA_BASE_FILE_H_

#include <string>
#include <vector>

#include "gaea/base/macros.h"

namespace gaea {
namespace base {

class File {
 public:
  /**
   * @function Save
   * @brief 将 content 保存到指定的文件目录下，内部保存以 "wb" 模式打开文件进行保存
   * @param path 待保存的目录路径
   * @param content 待保存的数据内容
   * @param error_message 如果发生错误，则输出内部具体错误信息
   * @return true 保存成功; false 保存失败
   **/
  static bool Save(const std::string& path, const std::string& content, std::string* error_message = nullptr);

  /**
   * @function Load
   * @brief 加载制定路径下的配置文件内容
   * @param path 配置文件路径
   * @param content 配置文件内容信息
   * @param error_message 错误信息
   * @return true 记载成功; false 加载失败
   */
  static bool Load(const std::string& path, std::string* content, std::string* error_message = nullptr);
};

} // end of namespace base
} // end of namespace gaea

#endif /* GAEA_BASE_FILE_H_ */
