//
//  file_function.hpp
//  gaea_base
//
//  Created by 胡建 on 2020/6/1.
//  Copyright © 2020 DingTalk. All rights reserved.
//

#ifndef GAEA_BASE_FILE_OPERATOR_H
#define GAEA_BASE_FILE_OPERATOR_H

#include <cstdio>

#include <fstream>
#include <iostream>
#include <map>
#include <string>
#include <vector>

#include "gaea/base/error_result.h"


namespace gaea {
namespace base {

class FileOperator {
 public:
  FileOperator(const std::string &file, int32_t mode = kAppend | kReadAndWrite | kBinary);
  FileOperator(int32_t mode = kAppend | kReadAndWrite | kBinary);
  virtual ~FileOperator();

  void Init(const std::string &file, int32_t mode = kAppend | kReadAndWrite | kBinary);
  // enum file open mode
  enum OpenMode {
    kReadOnly = 0x01,
    kWriteOnly = 0x02,
    kAppend = 0x04,
    kBinary = 0x08,
    kReadAndWrite = 0x10,
  };

  // enum file seek mode
  enum SeekMode {
    kSeekFromStart = 0,
    kSeekFromCurrent = 1,
    kSeekFromEnd = 2,
  };

  enum ErrorCode{
    kOutOfStorageError = 100,
    kFileIsDirError = 101,
    kFileNameIsEmptyError = 102,
    kPathIsIllgalError = 103,
    kOpenModeIsIllegalError = 104,
    kFileExistsAlreadyError = 105,
    kFileIsOpenAlreadyError = 106,
    kSystemError = 107,
    kFileIsNotOpenError = 108,
    kFileIsNotExistsError = 109,
    kSeekOffsetIllegalError = 110,
    kFileHandleOutOfEofError = 111,
    kWriteButOpenByReadOnlyError = 112,
    kReadButOpenByWriteOnlyError = 113,
    kBufferSizeLessThanZeroError = 114,
    kReadSizeMoreThanFileSizeError = 115,
    kFileNameIsSameError = 116,
    kReadStoragePointerIsEmpty = 117
  };

  void set_file(const std::string &file);
  const std::string get_file();

  void set_mode(int32_t mode);
  int32_t get_mode();

  bool IsExists(int32_t *error_code_ptr = nullptr);
  static bool IsExists(const std::string &file, int32_t *error_code_ptr = nullptr);

  bool Open(int32_t mode, int32_t *error_code_ptr = nullptr);
  bool Open(int32_t *error_code_ptr = nullptr);

  bool Close(int32_t *error_code_ptr = nullptr);

  bool IsEof();

  bool IsOpen();

  int64_t Size(int32_t *error_code_ptr = nullptr);

  bool Seek(int64_t offset, SeekMode fromwhere, int32_t *error_code_ptr = nullptr);

  bool Write(const std::string& data, int64_t data_size, int32_t *error_code_ptr = nullptr);

  int64_t Read(std::string *buffer, int64_t buffer_size, int32_t *error_code_ptr = nullptr);

  bool Create(int32_t *error_code_ptr = nullptr);
  static bool Create(const std::string &file, int32_t *error_code_ptr = nullptr);

  bool Remove(int32_t *error_code_ptr = nullptr);
  static bool Remove(const std::string &file, int32_t *error_code_ptr = nullptr);

  bool Copy(const std::string &to_file, int32_t *error_code_ptr = nullptr);
  static bool Copy(const std::string &from_file, const std::string &to_file, int32_t *error_code_ptr = nullptr);

  bool Rename(const std::string &to_file, int32_t *error_code_ptr = nullptr);
  static bool Rename(const std::string &from_file, const std::string &to_file, int32_t *error_code_ptr = nullptr);

  static const std::string GetErrorReason(int32_t error_code_ptr);

 private:
  bool GetOpenMethod(std::string *openway, int32_t *error_code_ptr = nullptr);

 private:
  // class member variables
  std::string file_;
  FILE *handle_;
  int32_t mode_;
};


} // end of namespace base
} // end of namespace gaea

#endif /* FILE_OPERATOR_H */


