﻿//
//  joiner.h
//  Atlas
//
//  Created by jinxi on 4/21/16.
//  Copyright © 2016 jinxi. All rights reserved.
//

#ifndef GAEA_BASE_JOINER_H_
#define GAEA_BASE_JOINER_H_

#include "gaea/base/macros.h"
#include "gaea/base/string_util.h"

namespace gaea {
namespace base {

class Joiner {
 public:
  Joiner();
  Joiner(const Joiner& joiner);
  Joiner& operator=(const Joiner& joiner);
  ~Joiner();

 public:
  Joiner& On(char separator);
  Joiner& On(const std::string& separator);
  /*
   * @desc: 对下述两种方式join操作时，skipEmptyString不起作用
   *        1. map类型
   *        2. 非string类型
   */
  Joiner& OmitEmptyString();
  Joiner& WithKeyValueSeparator(char separator);
  Joiner& WithKeyValueSeparator(const std::string& separator);

  std::string Join(const Strings& records);
  std::string Join(const StringMap& records);

  template <typename InputIterator>
  std::string Join(InputIterator first, InputIterator last) {
    return JoinListImpl(first, last);
  }

  template <typename InputIterator>
  std::string JoinMap(InputIterator first, InputIterator last) {
    return JoinMapImpl(first, last);
  }

 public:
  template <typename T>
  void AppendToString(std::string& result, const T& input) const {
    std::ostringstream oss;
    oss << input;
    result.append(oss.str());
  }
  template <typename T>
  void AppendToStream(std::ostream& result, const T& input) const {
    result << input;
  }

 private:
  template <typename InputIterator>
  std::string JoinListImpl(InputIterator first, InputIterator last) {
    std::string result;

    if (!(first != last)) {
      return result;
    }

    bool isFirst = true;
    if (IsString(*first)) {
      for (InputIterator it = first; it != last; ++it) {
        if (omit_empty_string_ && IsEmpty(*it)) {
          continue;
        }

        if (isFirst) {
          isFirst = false;
        } else {
          AppendToString(result, separator_);
        }
        AppendToString(result, *it);
      }
    } else {
      std::ostringstream oss;

      for (InputIterator it = first; it != last; ++it) {
        if (omit_empty_string_ && IsEmpty(*it)) {
          continue;
        }

        if (isFirst) {
          isFirst = false;
        } else {
          AppendToStream(oss, separator_);
        }
        AppendToStream(oss, *it);
      }
      result = oss.str();
    }

    return result;
  }

  template <typename InputIterator>
  std::string JoinMapImpl(InputIterator first, InputIterator last) {
    std::string result;

    if (!(first != last)) {
      return result;
    }

    bool isFirst = true;
    std::ostringstream oss;

    for (InputIterator it = first; it != last; ++it) {
      if (isFirst) {
        isFirst = false;
      } else {
        oss << separator_;
      }
      oss << it->first << key_value_separator_ << it->second;
    }
    result = oss.str();

    return result;
  }

  template <typename InputType>
  bool IsEmpty(const InputType& data) {
    return false;
  }

  template <typename InputType>
  bool IsString(const InputType& data) {
    return false;
  }

 private:
  std::string separator_;
  bool omit_empty_string_;
  std::string key_value_separator_;
};

// explicit specialization of template method
template <>
bool Joiner::IsEmpty<std::string>(const std::string& data);
template <>
bool Joiner::IsString<std::string>(const std::string& data);
template <>
void Joiner::AppendToString(std::string& result, const std::string& input) const;

} // end of namespace base
} // end of namespace gaea

#endif /* GAEA_BASE_JOINER_H_ */
