#ifndef GAEA_BASE_MICROS_H_
#define GAEA_BASE_MICROS_H_

// Platform
// see: https://sourceforge.net/projects/predef/
// http://nadeausoftware.com/articles/2012/01/c_c_tip_how_use_compiler_predefined_macros_detect_operating_system
#if defined(_WIN32)
  // 32- and 64-bit shared stuff
  #define GAEA_OS_WINDOWS
  #ifdef _WIN64
    // 64-bit specific stuff.
  #else
    // 32-bit specific stuff.
  #endif // _WIN64
#endif // _WIN32

#if defined(linux) || defined(__linux) || defined(__linux__)
  #define GAEA_OS_LINUX
#endif

#if defined(__APPLE__) && defined(__MACH__)
  // Apple OSX and iOS (Darwin)
  #include <TargetConditionals.h>
  #if TARGET_IPHONE_SIMULATOR == 1
    // iOS in Xcode simulator
    #define GAEA_OS_IOS
  #elif TARGET_OS_IPHONE == 1
    // iOS on iPhone, iPad, etc.
    #define GAEA_OS_IOS
  #elif TARGET_OS_MAC == 1
    // OSX
    #define GAEA_OS_MACOSX
  #endif
#endif

#if defined(__ANDROID__)
  #define GAEA_OS_ANDROID
#endif

#if !defined(_WIN32) && (defined(__unix__) || defined(__unix) || (defined(__APPLE__) && defined(__MACH__)))
// UNIX-style OS
#include <unistd.h>
#if defined(_POSIX_VERSION)
// POSIX compliant
  #define GAEA_OS_POSIX_COMPLIANT
#endif
#endif

#ifdef __cplusplus
#define GAEA_EXTERN    extern "C" __attribute__((visibility ("default")))
#else
#define GAEA_EXTERN    extern __attribute__((visibility ("default")))
#endif


#if defined(GAEA_BASE_EXPORT) || defined(GAEA_EXPORT)

#ifdef _WIN32
#define GAEA_BASE_DECL __declspec(dllexport)
#else
#define GAEA_BASE_DECL __attribute__((visibility("default")))
#endif

#else
#define GAEA_BASE_DECL
#endif

#endif // GAEA_BASE_MICROS_H_
