﻿//
//  TimeUnit.hpp
//  Atlas
//
//  Created by jinxi on 4/21/16.
//  Copyright © 2016 jinxi. All rights reserved.
//

#ifndef GAEA_BASE_TIME_UNIT_H_
#define GAEA_BASE_TIME_UNIT_H_

#include <cstdint>
#include <string>

#include "gaea/base/macros.h"

namespace gaea {
namespace base {

class TimeUnit {
 public:
  TimeUnit();
  TimeUnit(const std::string& duration);
  ~TimeUnit();

  bool ParseString(const std::string& duration);

  bool has_error() const { return has_error_; }

  int64_t Days() const;
  int64_t Hours() const;
  int64_t Minutes() const;
  int64_t Seconds() const;
  int64_t Millis() const;
  int64_t Micros() const;
  int64_t Nanos() const;

 private:
  int64_t seconds_;
  int64_t nanos_;
  bool has_error_;
};

} // end of namespace base
} // end of namespace gaea

#endif /* GAEA_BASE_TIME_UNIT_H_ */
