//
//  trace_context.hpp
//  GaeaBase
//
//  Created by Herb on 2019/7/3.
//  Copyright © 2019年 DingTalk. All rights reserved.
//

#ifndef GAEA_BASE_TRACE_CONTEXT_H_
#define GAEA_BASE_TRACE_CONTEXT_H_

#include <stdio.h>
#include <string>
#include <map>
#include <functional>

#include "gaea/base/macros.h"

namespace gaea {
namespace base {

#define GENERATE_TRACE_ID_INTERFACE std::function<const std::string (const std::string&,  )>
  
class TraceContext {
 public:
  TraceContext();
  virtual ~TraceContext();
  
  void set_trace_id(const std::string& trace_id);
  const std::string& trace_id() const { return trace_id_; }
  
  void set_mid(const std::string& mid) { mid_ = mid; }
  const std::string& mid() const { return mid_; }
  
  void set_sid(const std::string& sid) { sid_ = sid; }
  const std::string& sid() const { return sid_; }
  
  void set_enable_dye(bool enable_dye) { enable_dye_ = enable_dye; }
  bool enable_dye() const { return enable_dye_; }

  // accs use only
  void set_accs_data_id(const std::string& accs_data_id) { accs_data_id_ = accs_data_id; }
  const std::string& accs_data_id() const { return accs_data_id_; }
  
 private:
  void ParseTraceId();

 private:
  std::string trace_id_;
  std::string mid_;
  std::string sid_;
  std::string accs_data_id_;
  bool enable_dye_;
};

class TraceGenerator {
 public:
  static const std::string GenerateTraceId(bool enable_dye, const std::string& mid, const std::string& sid);
};


} // end of namespace base
} // end of namespace gaea

#endif /* GAEA_BASE_TRACE_CONTEXT_H_ */
