//
//  config_service_delegate.h
//  GaeaConfig
//
//  Created by Herb on 2019/3/7.
//  Copyright © 2019年 DingTalk. All rights reserved.
//

#ifndef GAEA_CONFIG_SERVICE_DELEGATE_H_
#define GAEA_CONFIG_SERVICE_DELEGATE_H_

#include <stdio.h>

namespace gaea {
namespace config {
/**
 * 配置服务外部代理类
 * */
class ConfigServiceDelegate {
public:
  ConfigServiceDelegate() {}
  virtual ~ConfigServiceDelegate() {}
  
  /**
   * 获取远端配置版本号
   * */
  virtual int64_t GetRemoteIndexConfigVersion() = 0;
  
  /**
   * 获取远端配置数据下载 URL
   */
  virtual const std::string GetRemoteIndexConfigDownloadUrl() = 0;
  
  /**
   * 配置变更
   */
  virtual void OnConfigChanged(
      int error_code,
      const std::string& error_message,
      const std::multimap<std::string, std::string> update_list) = 0;
  
  /**
   * 监听配置服务启动成功回调
   */
  virtual void OnConfigServiceStartedSuccess() = 0;
  
  /**
  * 监听配置服务启动失败回调
  */
  virtual void OnConfigServiceStartedFailure(int error_code, const std::string& error_message) = 0;
};
typedef std::shared_ptr<ConfigServiceDelegate> ConfigServiceDelegatePtr;
typedef std::weak_ptr<ConfigServiceDelegate> ConfigServiceDelegateWeakPtr;

} // end of namespace config
} // end of namespace gaea

#endif /* config_service_delegate_h */
