//
//  config_service_interface_delegate.h
//  GaeaConfig
//
//  Created by Herb on 2019/9/12.
//  Copyright © 2019年 DingTalk. All rights reserved.
//

#ifndef CONFIG_SERVICE_INTERFACE_DELEGATE_H_
#define CONFIG_SERVICE_INTERFACE_DELEGATE_H_

#include <map>
#include <string>
#include <future>

#include "gaea/config/user_info_model.h"

namespace gaea {
namespace config {

class ConfigServiceInterfaceDelegate {
 public:
  virtual ~ConfigServiceInterfaceDelegate() {}
  virtual void OnStarted(
      int service_id,
      int error_code,
      const std::string& error_message) = 0;
  
  virtual void OnUpdated(
      int service_id,
      int error_code,
      const std::string& error_message,
      const std::multimap<std::string, std::string>& change_list) = 0;
  
  virtual int64_t GetRemoteIndexVersion() = 0;
  
  virtual const std::string GetRemoteIndexDownloadUrl() = 0;
  
  virtual const UserInfoModel& user_info() = 0;
  
  virtual bool GetStartOptimiseSwitch() = 0;
};

}
}

#endif /* CONFIG_SERVICE_INTERFACE_DELEGATE_H_ */
