//
//  accs_service_push_listener.h
//  TBiOSVirtualSocket
//
//  Created by guodi.ggd on 2019/6/24.
//  Copyright © 2019 dingtalk.com. All rights reserved.
//

#ifndef accs_service_push_listener_h
#define accs_service_push_listener_h

#include <stdio.h>
#include <map>
#include <mutex>
#include <memory>

#include "gaea/base/macros.h"
#include "gaea/base/logging.h"
#include "gaea/extension/accs/accs_observer_delegate.h"
#include "gaea/extension/accs/taobao_accs_notify_interface.h"


GAEA_LWP_NAMESPACE_BEGIN
#ifdef GAEA_OS_WINDOWS
  typedef std::mutex  GaeaRwLock;
  #define GAEA_RWLOCK_INIT(rw_lock)
  #define GAEA_RWLOCK_DESTROY(rw_lock)
  #define GAEA_RDLOCK(rw_lock)  rw_lock.lock()
  #define GAEA_WRLOCK(rw_lock)  rw_lock.lock()
  #define GAEA_UNLOCK(rw_lock)  rw_lock.unlock()
#else
  typedef pthread_rwlock_t GaeaRwLock;
  #define GAEA_RWLOCK_INIT(rw_lock)     pthread_rwlock_init(&rw_lock, NULL)
  #define GAEA_RWLOCK_DESTROY(rw_lock)  pthread_rwlock_destroy(&rw_lock)
  #define GAEA_RDLOCK(rw_lock)          pthread_rwlock_rdlock(&rw_lock)
  #define GAEA_WRLOCK(rw_lock)          pthread_rwlock_wrlock(&rw_lock)
  #define GAEA_UNLOCK(rw_lock)          pthread_rwlock_unlock(&rw_lock)
#endif

  class AccsServicePushListener : public TaobaoAccsNotifyInterface {
   public:
    AccsServicePushListener();
    ~AccsServicePushListener();
    void RemoveObserver(const std::string& connect_key);
    void AddObserver(const std::string& connect_key, ObserverListenerPtr listener);
    
    virtual void OnRecvData(const std::string& tag, const std::string& buf) override;
    virtual void OnSendDataError(const std::string& tag,
                             const std::string& data_id,
                             const gaea::base::ErrorResult& error_result) override;
    virtual void OnAccsStatusChanged(bool is_available) override;
   private:
    bool ParseRouteContext(std::string tag_value, paas::RouteContext *route_ctx);
    void Dispatch(const std::string &dispatchKey,
                  const std::string& buf,
                  const paas::RouteContext& route_ctx,
                  const std::string& tag);
    void DispatchError(const std::string &dispatchKey);
   private:
    gaea::base::Logger logger_;
    std::map<std::string, ObserverListenerPtr> push_listeners_;
	  GaeaRwLock rw_lock_;
  };
GAEA_LWP_NAMESPACE_END
#endif /* accs_service_push_listener_h */

