//
//  accs_virtual_socket.h
//  DTOpenIMTaobaoContainerDemo
//
//  Created by guodi.ggd on 2019/5/13.
//  Copyright © 2019 dingtalk.com. All rights reserved.
//

#ifndef accs_virtual_socket_h
#define accs_virtual_socket_h

#include <stdio.h>
#include "gaea/lwp/gaea_define.h"
#include "gaea/lwp/virtual_socket.h"
#include "gaea/extension/accs/route_context.h"
#include "gaea/extension/accs/accs_observer_delegate.h"

GAEA_LWP_NAMESPACE_BEGIN

  class AccsVirtualSocket : public gaea::lwp::VirtualSocket,
                           public ObserverListener,
                           public std::enable_shared_from_this<AccsVirtualSocket>
  {
   public:
    AccsVirtualSocket();
    virtual ~AccsVirtualSocket();
    
    int SendData(const std::string& data, TransferContextPtr transfer_context) override;
    void Connect() override;
    void Disconnect() override;
    void set_net_eventloop(gaea::lwp::EventLoopPtr el) {net_eventloop_ = el;}

  private:
    int SendData(const std::string& data, const std::string& tag, bool need_callback);
    const std::string GenerateFD();
    void OnError(ConnErrorType err_type);
    
    const std::string& listen_key() { return listen_key_; };
    
    void AddListener(const std::string& listen_key);
    void RemoveListener(const std::string& listen_key);
    
    void set_rp(const std::string& rp) {rp_ = rp;}
    const std::string& rp() {return rp_;}
    
    virtual void DidRecvAccsBuf(const std::string &buffer,
                                const paas::RouteContext& route_ctx,
                                const std::string& tag) override;
    virtual void OnNetworkStatusChanged(bool is_network_valid) override;
    virtual void OnRecvError() override;
    
    const std::string& DataRouteTag(TransferContextPtr transfer_context);
    std::string ConnRouteTag();
    std::string DisconnRouteTag();
    
    void __DidRecvAccsBuf(const std::string &buffer,
                          const paas::RouteContext& route_ctx,
                          const std::string& tag);
    void __Connect();
    
    void Close();

    RequestPtr BuildConnRequest();
    RequestPtr BuildDisconnRequest();
    void SendDisconnectDataIfNeed();
  private:
    gaea::base::Logger logger_;
    int tag_print_count_;
    std::string conn_req_mid_;
    std::string rp_;
    std::string listen_key_;
    paas::RouteContext route_ctx_;
    std::string data_route_tag_;
    gaea::lwp::EventLoopPtr net_eventloop_;
    bool is_connected_;
    
    const static std::string kLwpAccsConnUri;
    const static std::string kLwpAccsDisconnUri;
  };
GAEA_LWP_NAMESPACE_END

#endif /* accs_virtual_socket_h */

