//
//  taobao_accs_interface.h
//  TBiOSVirtualSocket
//
//  Created by guodi.ggd on 2019/6/26.
//  Copyright © 2019 dingtalk.com. All rights reserved.
//

#ifndef taobao_accs_interface_h
#define taobao_accs_interface_h

#include <memory>
#include <functional>
#include "gaea/lwp/gaea_define.h"
#include "gaea/extension/accs/accs_service_push_listener.h"

GAEA_LWP_NAMESPACE_BEGIN
  typedef std::function<void (bool result, const gaea::base::ErrorResult& err)> SendDataCallback;

  class TaobaoAccsInterface {
   public:
    TaobaoAccsInterface();
    virtual ~TaobaoAccsInterface() {}
    
    virtual std::string SendData(const std::string& data,
                                 const std::string& tag,
                                 SendDataCallback callback) = 0;
    
    virtual void AddObserver(const std::string& connect_key, ObserverListenerPtr listener);
    virtual void RemoveObserver(const std::string& connect_key);
   protected:
    gaea::base::Logger logger_;
    AccsServicePushListener accs_push_listener_;
  };
  typedef std::shared_ptr<TaobaoAccsInterface> TaobaoAccsInterfacePtr;
GAEA_LWP_NAMESPACE_END
#endif /* taobao_accs_interface_h */
