//
//  taobao_accs_manager.h
//  TBiOSVirtualSocket
//
//  Created by guodi.ggd on 2019/6/26.
//  Copyright © 2019 dingtalk.com. All rights reserved.
//

#ifndef taobao_accs_manager_h
#define taobao_accs_manager_h

#include <stdio.h>
#include <string>
#include <functional>
#include "gaea/base/singleton.h"
#include "taobao_accs_interface.h"
#include "gaea/lwp/gaea_define.h"

GAEA_LWP_NAMESPACE_BEGIN
  class TaobaoAccsManager : public gaea::base::Singleton<TaobaoAccsManager> {
   public:
    TaobaoAccsManager();
    virtual ~TaobaoAccsManager();
    
    void set_accs_impl(TaobaoAccsInterfacePtr accs_impl);
    std::string SendData(const std::string& data,
                                 const std::string& tag,
                                 SendDataCallback callback);
    void AddObserver(const std::string& topic, ObserverListenerPtr listener) ;
    void RemoveObserver(const std::string& topic);
  private:
    void CommitSlowSend(double api_cost_time);
  private:
    TaobaoAccsInterfacePtr accs_impl_;
    gaea::base::Logger logger_;
    volatile int64_t send_count_;
  };
GAEA_LWP_NAMESPACE_END

#endif /* taobao_accs_manager_h */
