//
//  atlas_adaptor.hpp
//  gaea_lwp
//
//  Created by Herb on 2020/8/3.
//  Copyright © 2020 DingTalk. All rights reserved.
//

#ifndef GAEA_LWP_EXTENSION_ATLAS_ADAPTOR_H_
#define GAEA_LWP_EXTENSION_ATLAS_ADAPTOR_H_

#include <functional>
#include <memory.h>

#include <gaea/lwp/gaea_define.h>

namespace gaea {
namespace lwp {

class Request;
typedef std::shared_ptr<Request> RequestPtr;

class RequestContext;
typedef std::shared_ptr<RequestContext> RequestContextPtr;

typedef std::function<bool()> OnPreSubscribeCallBack;
typedef std::function<std::string ()> OnGetAccessTokenCallBack;
typedef std::function<void(RequestPtr request)> OnBuildRequestCallBack;

class SubscribeExternInfo {
 public:
  SubscribeExternInfo() {}
  virtual ~SubscribeExternInfo() {}

  void set_on_pre_subscribe(OnPreSubscribeCallBack callback) { on_pre_subscribe_ = callback; }
  OnPreSubscribeCallBack on_pre_subscribe() { return on_pre_subscribe_; }
  
  void set_on_build_request(OnBuildRequestCallBack callback) { on_build_request_ = callback; }
  OnBuildRequestCallBack on_build_request() { return on_build_request_; }

  void set_final_callback(CheckAuthCallback callback) { final_callback_ = callback; }
  CheckAuthCallback final_callback() { return final_callback_; }
  
  void set_on_get_access_token(OnGetAccessTokenCallBack callback) { on_get_access_token_ = callback; }
  OnGetAccessTokenCallBack on_get_access_token() { return on_get_access_token_; }
  
 private:
  CheckAuthCallback final_callback_;
  OnGetAccessTokenCallBack on_get_access_token_;
  OnBuildRequestCallBack on_build_request_;
  OnPreSubscribeCallBack on_pre_subscribe_;
};

typedef std::shared_ptr<SubscribeExternInfo> SubscribeExternInfoPtr;

}
}

#endif /* GAEA_LWP_EXTENSION_ATLAS_ADAPTOR_H_ */
