//
//  fastconfig_request_filter.hpp
//  gaea_lwp
//
//  Created by 司沐 on 2020/8/3.
//  Copyright © 2020 DingTalk. All rights reserved.
//
#ifndef GAEA_LWP_FILTER_FASTCONFIG_FILTER_H_
#define GAEA_LWP_FILTER_FASTCONFIG_FILTER_H_

#include <stdio.h>
#include <mutex>

#include "gaea/filter/message_filter.h"

GAEA_LWP_NAMESPACE_BEGIN

extern const char * kFastconfigFilterName;

class FastconfigFilter : public MessageFilter {
public:
  typedef std::function<void(const std::string& cs_idx_ver_value,
                             const std::string& cs_idx_url_value)> FastconfigMonitorCallback;
  
  FastconfigFilter(FastconfigMonitorCallback onCapture);
  virtual ~FastconfigFilter();
  
public:  
  void ProcessPush(RequestPtr request) override ;
  void ProcessResponse(ResponsePtr response) override;
  
  void CheckFastConfigInfo(const std::string& version, const std::string& index_url);
  
private:
  FastconfigMonitorCallback on_capture_;
  gaea::base::Logger logger_;
  std::mutex mutex_;
  std::string fastconfig_version_;
  std::string fastconfig_index_url_;
};

GAEA_LWP_NAMESPACE_END

#endif /* fastconfig_request_filter_hpp */
