//
//  filter_chain.hpp
//  GaeaLwp
//
//  Created by 司沐 on 2020/8/3.
//  Copyright © 2020 DingTalk. All rights reserved.
//

#ifndef GAEA_LWP_FILTER_FILTER_CHAIN_H_
#define GAEA_LWP_FILTER_FILTER_CHAIN_H_

#include <stdio.h>
#include <memory>
#include <list>

#include "gaea/base/singleton.h"
#include "gaea/filter/message_filter.h"


GAEA_LWP_NAMESPACE_BEGIN

class FilterChain {
public:
  FilterChain();
  virtual ~FilterChain();
  
  /* add common routine filter,  */
  bool AddRoutineFilter(MessageFilterPtr filter);
  
  /* add will interrupt filter */
  bool AddStickFilter(MessageFilterPtr filter);
  
  /**
   *  @return true present  will take over the request;
   */
  bool InvokeProcessRequest(RequestPtr request, RequestContextPtr context);
  void InvokeProcessPush(RequestPtr request);
  void InvokeProcessResponse(ResponsePtr response);
  
private:
  gaea::base::Logger logger_;
  int64_t warning_cost_time_;
  std::list<MessageFilterPtr> routine_filters_;
  std::list<MessageFilterPtr> stick_filters_;
};

GAEA_LWP_NAMESPACE_END

#endif /* filter_chain_hpp */

