/*
* =====================================================================================
*
*       Filename:  base_model.h
*
*    Description:  Base classes of all models
*
*        Version:  1.0
*        Created:  2019-04-30
*       Revision:  none
*       Compiler:  gcc
*
*         Author: jack.kj@alibaba-inc.com
*
* =====================================================================================
*/
#ifndef GAEA_IDL_BASE_MODEL_H_
#define GAEA_IDL_BASE_MODEL_H_

#include <vector>
#include "gaea/idl/base_model_value.h"

namespace gaea {
namespace idl {

#ifndef GAEA_IDL_DISABLE_JSON
struct JsonSerializeContext;
struct JsonDeSerializeContext;
#endif

class BaseModel {
  friend class ModelJsonHelper;
  friend class ModelMsgpackHelper;

public:
  BaseModel();
  virtual ~BaseModel();

#ifndef GAEA_IDL_DISABLE_JSON
  bool ToJson(std::string *output) const;
  bool FromJson(const std::string &json);
#endif

  bool Pack(std::string *output) const;
  bool Unpack(const std::string &input, std::string *errorMessage = nullptr,
              bool* is_missing_fields = nullptr);

  enum MergeMode {
    // only not present value or type is sub model value will merged
    kMergeOnlyMissedOrModelValueType = 0
  };

  void MergeFrom(const BaseModel& other, MergeMode mode = MergeMode::kMergeOnlyMissedOrModelValueType);

  inline bool IsPresent() const { return is_present_; }

  void Clear();
  inline void clear() { Clear(); }

 protected:
  virtual int GetModelSize() const = 0;
  virtual void GetValues(BaseModelValue **baseModelValue) = 0;

 private:
  // json convert
#ifndef GAEA_IDL_DISABLE_JSON
   bool ToJson(const std::string &key, JsonSerializeContext* context) const;
   bool ToJson(JsonSerializeContext* context) const;
   bool FromJson(const JsonDeSerializeContext* context);
   template <class NodeType>
   bool FromJsonTemplate(const NodeType *node_type);
#endif

  bool Unpack(cmp_ctx_t *ctx, bool *is_nil, bool *is_missing_fields);
  bool Pack(cmp_ctx_t *ctx) const;



  bool is_present_;
};

} // namespace idl
} // namespace gaea

#endif
