//
//  msgpack_helper.h
//  Atlas
//
//  Created by jinxi on 5/24/16.
//  Copyright © 2016 jinxi. All rights reserved.
//

#ifndef GAEA_IDL_MSG_PACK_H_
#define GAEA_IDL_MSG_PACK_H_

#include <map>
#include <string>
#include <vector>
#include "gaea/contrib/cmp.h"
#include "gaea/idl/base_model.h"

namespace gaea {
namespace idl {
namespace MsgPackHelper {

struct MsgpackContext {
  const char* data;
  int64_t begin;
  int64_t size;
  cmp_ctx_t* cmp;
};

bool MsgpackContextReader(cmp_ctx_t* ctx, void* data, size_t count);
size_t MsgpackStringWriter(cmp_ctx_t *ctx, const void *data, size_t count);

bool SkipOneObject(cmp_ctx_t *cmp);

} // end of namespace MsgPackHelper
} // end of namespace idl
} // end of namespace gaea

#endif /* GAEA_IDL_MSG_PACK_H_ */
