/*
 * =====================================================================================
 *
 *       Filename:  simple_model_value.h
 *
 *    Description:  简单的model的辅助类
 *
 *        Version:  1.0
 *        Created:  2019-05-06
 *       Revision:  none
 *       Compiler:  gcc
 *
 *         Author:  偌里, jack.kj@alibaba-inc.com
 *
 * =====================================================================================
 */
#ifndef GAEA_LWP_SIMPLE_MODEL_VALUE_H
#define GAEA_LWP_SIMPLE_MODEL_VALUE_H

#include <stdint.h>
#include <string.h>
#include <string>

namespace gaea {
    namespace lwp {

        template <typename T, bool is_class = std::is_class<T>::value >
        struct DefaultValue {
        };

        template <typename T>
        struct DefaultValue<T, false> {
            static void Clear(T* value) {
                memset(value, 0, sizeof(T));
            }
        };

        template <typename T>
        struct DefaultValue<T, true> {
            static void Clear(T* value) {
                value->clear();
            }
        };

        template <>
        struct DefaultValue<int32_t> {
            static void Clear(int32_t * value) {
                *value = 0;
            }
        };

        template <typename T>
        class SimpleModelValue {
        public:
            SimpleModelValue(): is_present_(false){
            }
            ~SimpleModelValue() = default;

            void Clear() {
                is_present_ = false;
                DefaultValue<T>::Clear(&value_);
            }

            inline void Set(const T &value) {
                value_ = value;
                is_present_ = true;
            }

            inline void Set(T&& value) {
                value_ = value;
                is_present_ = true;
            }

            inline T *Mutable() {
                is_present_ = true;
                return &value_;
            }

            inline const T &Get() const {
                return value_;
            }

            inline bool IsPresent() const {
                return is_present_;
            }


        private:
            bool is_present_;
            T value_;
        };
    }
}

#endif //GAEA_LWP_SIMPLE_MODEL_VALUE_H
