//
//  database_interface.h
//  GaeaInterface
//
//  Created by Herb on 2019/9/18.
//  Copyright © 2019年 DingTalk. All rights reserved.
//

#ifndef GAEA_SERVICE_DATABASE_WRAPPER_H_
#define GAEA_SERVICE_DATABASE_WRAPPER_H_

#include <memory>
#include <string>

#include "gaea/interface/base_interface.h"
#include "gaea/interface/database/database_context.h"

namespace gaea {
namespace service {

class DatabaseWrapper : public BaseInterface {
 public:
  DatabaseWrapper() {}
  virtual ~DatabaseWrapper() {}
  
  const DatabaseContext& context() const { return context_; }
  DatabaseContext* mutable_context() { return &context_; }
  void set_context(const DatabaseContext& context) { context_ = context; }

 protected:
  DatabaseContext context_;
};
typedef std::shared_ptr<DatabaseWrapper> DatabaseWrapperPtr;

}
}

#endif /* GAEA_SERVICE_DATABASE_WRAPPER_H_ */

