//
//  FileProgress.hpp
//  Atlas
//
//  Created by jinxi on 8/4/16.
//  Copyright © 2016 jinxi. All rights reserved.
//

#ifndef GAEA_INTERFACE_FILE_FILE_PROGRESS_H_
#define GAEA_INTERFACE_FILE_FILE_PROGRESS_H_

#include <cstdint>
#include <string>

namespace gaea {
namespace service {

class FileProgress {
public:
  FileProgress() : value_(0), total_(0) {}
  ~FileProgress() {}

public:
  int64_t value() const { return value_; }
  void set_value(int64_t value) { value_ = value; }

  int64_t total() const { return total_; }
  void set_total(int64_t total) { total_ = total; }

  const std::string& buffer() const { return buffer_; }
  void set_buffer(const std::string& buffer) { buffer_ = buffer; }

public:
  // Returns the upload, download progress, floating point number returns, value range[0, 1], 0 means 0 % , 1 means 100
  // % ; for example, 0.98 means 98 % ; 1, when total == 0, return 0 2, (developers generally don't have to think about
  // it) because of a bug that causes value < 0, or total < 0, returns 0% 3, (developers generally don't have to think
  // about it) When the value is > total due to bug, return 100%
  double getRate() const;

  // Returns the upload, download progress, the string form returns, for example 98 % , does not support the part after
  // the decimal point, need higher precision first use double getRate() interface 1, when total == 0, return 0%
  const std::string getRateString() const;

private:
  int64_t value_;      // current progress. Upload: send total bytes count; Download: Received bytes count.
  int64_t total_;      // Upload or Download file total size.
  std::string buffer_; // current storage the datas of added.
};

}
}
#endif /* GAEA_INTERFACE_FILE_FILE_PROGRESS_H_ */
