//
//  upload_callback.h
//  quic_file
//
//  Created by guodi.ggd on 2020/8/9.
//

#ifndef GAEA_INTERFACE_FILE_UPLOAD_CALLBACK_H_
#define GAEA_INTERFACE_FILE_UPLOAD_CALLBACK_H_

#include "gaea/base/error_result.h"
#include "gaea/interface/file/file_progress.h"
#include "gaea/interface/file/file_upload_result.h"
#include "gaea/interface/file/file_upload_task.h"

namespace gaea {
namespace service {

class FileUploadCallback {
public:
  FileUploadCallback();
  virtual ~FileUploadCallback();
  
  void SetCallback(std::function<void()> on_start,
                   std::function<void(const gaea::service::FileProgress&)> on_progress,
                   std::function<void(const gaea::service::FileUploadResult&)> on_success,
                   std::function<void(const gaea::base::ErrorResult&)> on_failure);
  
  std::function<void()> on_start() const { return on_start_; }
  std::function<void(const gaea::service::FileProgress&)> on_progress() const { return on_progress_; }
  std::function<void(const gaea::service::FileUploadResult&)> on_success() const { return on_success_; }
  std::function<void(const gaea::base::ErrorResult&)> on_failure() const { return on_failure_; }
  
private:
  std::function<void()> on_start_;
  std::function<void(const gaea::service::FileProgress&)> on_progress_;
  std::function<void(const gaea::service::FileUploadResult&)> on_success_;
  std::function<void(const gaea::base::ErrorResult&)> on_failure_;
};
typedef std::shared_ptr<FileUploadCallback> FileUploadCallbackPtr;

}
}

#endif /* GAEA_INTERFACE_FILE_UPLOAD_CALLBACK_H_ */
