//
//  HttpHeader.h
//  Atlas
//
//  Created by jinxi on 22/09/2016.
//  Copyright © 2016 jinxi. All rights reserved.
//

#ifndef GAEA_INTERFACE_HTTP_HEADER_H_
#define GAEA_INTERFACE_HTTP_HEADER_H_

#include <map>
#include <memory>
#include <string>

namespace gaea {
namespace service {

extern const char *kHttpContentTypeName;
extern const char *kHttpContentLengthName;
extern const char *kHttpUserAgentName;

/**
 * http 状态码定义
 */
enum HttpStatus {
  kStatusContinue = 100,
  kStatusSwitchingProtocols = 101,
  kStatusProcessing = 102,
  kStatusSuccess = 200,
  kStatusCreated = 201,
  kStatusAccepted = 202,
  kStatusNonAuthoritativeInformation = 203,
  kStatusNoContent = 204,
  kStatusResetContent = 205,
  kStatusPartialContent = 206,
  kStatusMultiStatus = 207,
  kStatusMultipleChoices = 300,
  kStatusMovedPermanently = 301,
  kStatusFound = 302,
  kStatusSeeOther = 303,
  kStatusNotModified = 304,
  kStatusUseProxy = 305,
  kStatusSwitchProxy = 306,
  kStatusTemporaryRedirect = 307,
  kStatusPermanentRedirect = 308,
  kStatusBadRequest = 400,
  kStatusUnauthorized = 401,
  kStatusPaymentRequired = 402,
  kStatusForbidden = 403,
  kStatusNotFound = 404,
  kStatusMethodNotAllowed = 405,
  kStatusNotAcceptable = 406,
  kStatusProxyAuthenticationRequired = 407,
  kStatusRequestTimeout = 408,
  kStatusConflict = 409,
  kStatusGone = 410,
  kStatusLengthRequired = 411,
  kStatusPreconditionFailed = 412,
  kStatusRequestEntityTooLarge = 413,
  kStatusRequestUriTooLong = 414,
  kStatusUnsupportedMediaType = 415,
  kStatusRequestedRangeNotSatisfiable = 416,
  kStatusExpectationFailed = 417,
  kStatusUpgradeRequired = 426,
  kStatusPreconditionRequired = 428,
  kStatusTooManyRequest = 429,
  kStatusRequestHeaderFieldsTooLarge = 431,
  kStatusUnavailableForLegalReasons = 451,
  kStatusInternalServerError = 500,
  kStatusNotImplemented = 501,
  kStatusBadGateway = 502,
  kStatusServiceUnavailable = 503,
  kStatusGatewayTimeout = 504,
  kStatusHttpVersionNotSupported = 505,
  kStatusHttpVariantAlsoNegotiates = 506,
  kStatusHttpNetworkAuthenticationRequired = 511,
};

const char* GetHttpStatusDescription(HttpStatus code);

typedef std::multimap<std::string, std::string> HeaderMap;
  
class HttpHeader {
 public:
  HttpHeader() {}
  
  HttpHeader(const HttpHeader& other) { this->headers_ = other.headers_; }
  
  virtual ~HttpHeader() {}
  
  bool HasHeader(const std::string& name) const;
  const std::string GetHeader(const std::string& name, const std::string& defaultValue = "") const;
  
  void RemoveHeader(const std::string& name);
  void AddHeader(const std::string& name, const std::string& value);
  void SetHeader(const std::string& name, const std::string& value);

  const HeaderMap& Headers() const { return headers_; }
  std::string ToString() const;
  
  void set_headers(const HeaderMap& headers) { headers_ = headers; }
  HttpHeader& operator=(const HttpHeader& other) {
    this->headers_ = other.headers_;
    return *this;
  }
  
 private:
  HeaderMap headers_;
};
typedef std::shared_ptr<HttpHeader> HttpHeaderPtr;

} // end of namespace service
} // end of namespace gaea

#endif /* GAEA_INTERFACE_HTTP_HEADER_H_ */
