//
//  HttpRequest.h
//  Atlas
//
//  Created by jinxi on 22/09/2016.
//  Copyright © 2016 jinxi. All rights reserved.
//

#ifndef GAEA_INTERFACE_HTTP_REQUEST_H_
#define GAEA_INTERFACE_HTTP_REQUEST_H_

#include <memory>
#include <string>

#include "gaea/interface/http/http_header.h"

namespace gaea {
namespace service {

class HttpRequest {
 public:
  HttpRequest() {}
  
  virtual ~HttpRequest() {}

  static const std::string kMethodGet;
  static const std::string kMethodPost;
  static const std::string kMethodHead;
  static const std::string kMethodOptions;
  static const std::string kMethodPut;
  static const std::string kMethodDelete;
  static const std::string kMethodTrace;

  const std::string& url() const { return url_; }
  void set_url(const std::string& url) { url_ = url; }

  HttpHeader* mutable_header() { return &header_; }
  const HttpHeader& header() const { return header_; }
  void set_header(const HttpHeader& header) { header_ = header; }

  std::string* mutable_payload() { return &payload_; }
  const std::string& payload() const { return payload_; }
  void set_payload(const std::string& payload) { payload_ = payload; }

  /**
   * @function set_method
   * @brief Set the method for the URL request,
   *    one of: GET POST HEAD OPTIONS PUT DELETE TRACE are legal,
   *    subject to protocol restrictions.
   */
  const std::string& method() const;
  void set_method(const std::string& method);

 private:
  std::string url_;
  HttpHeader header_;
  std::string payload_;
  std::string method_;
};
typedef std::shared_ptr<HttpRequest> HttpRequestPtr;

} // end of namespace service
} // end of namespace gaea

#endif /* GAEA_INTERFACE_HTTP_REQUEST_H_ */
