//
//  service_factory.h
//  GaeaInterface
//
//  Created by Herb on 2019/2/21.
//  Copyright © 2019 DingTalk. All rights reserved.
//

#ifndef GAEA_SERVICE_FACTORY_H_
#define GAEA_SERVICE_FACTORY_H_

#include <stdio.h>
#include <map>
#include <memory>
#include <mutex>

#include "gaea/base/logging.h"
#include "gaea/base/singleton.h"
#include "gaea/interface/base_interface.h"

namespace gaea {
namespace service {

/**
 * service factory class
 */
class ServiceFactory : public gaea::base::Singleton<ServiceFactory> {
 public:
  ServiceFactory();
  virtual ~ServiceFactory();
  
  /**
   * @function RegisterService
   * @brief registe interface impl by service name
   *        factory will not free interface_implement, who create impl has response to free
   * @param service_name service name 
   * @param interface_implement service impl
   * @Descript
   */
  void RegisterService(const std::string& service_name,
                       BaseInterfacePtr interface_implement);
  
  /**
   * @function GetService
   * @brief find interface impl object by service name 
   * @param service_name service name 
   * @return return service impl object by name, return nullptr if cannot find or invalid service name
   */
  const BaseInterfacePtr GetService(const std::string& service_name);
  void DeregisterService(const std::string& service_name);
  /**
   * @function service_map
   * @brief return current service map table
   * @return current service map table
   */
  std::map<std::string, BaseInterfacePtr>& mutable_service_map() { return service_map_; }
  
 private:
  gaea::base::Logger logger_;
  std::mutex mutex_;
  
  /**
   * current service map
   */
  std::map<std::string, BaseInterfacePtr> service_map_;
};


} // namespace of service
} // nsmespace of gaea

#endif /* GAEA_SERVICE_FACTORY_H_ */
