//
//  switch_service_interface.h
//  gaea_interface
//
//  Created by Herb on 2020/5/9.
//  Copyright © 2020 DingTalk. All rights reserved.
//

#ifndef GAEA_SERVICE_SWITCH_SERVICE_INTERFACE_H_
#define GAEA_SERVICE_SWITCH_SERVICE_INTERFACE_H_

#include <string>

#include "gaea/interface/base_interface.h"

namespace gaea {
namespace service {

class SettingInterface : public BaseInterface {
 public:
  SettingInterface() {}
  virtual ~SettingInterface();
  
  virtual const std::string GetString(
      const std::string& module,
      const std::string& key,
      const std::string& default_value);

  virtual bool GetBool(
      const std::string& module,
      const std::string& key,
      bool default_value);
};
typedef std::shared_ptr<SettingInterface> SettingInterfacePtr;

} // end of namespace service
} // end of namespace gaea

#endif /* GAEA_SERVICE_SWITCH_SERVICE_INTERFACE_H_ */
