//
//  sync_interface.h
//  gaea_interface
//
//  Created by Herb on 2020/6/19.
//  Copyright © 2020 DingTalk. All rights reserved.
//

#ifndef GAEA_INTERFACE_SYNC_SERVICE_H_
#define GAEA_INTERFACE_SYNC_SERVICE_H_

#include <stdio.h>
#include <string>
#include "gaea/interface/base_interface.h"


namespace gaea {
namespace service {

class SyncInterface : public BaseInterface {
 public:
  /**
   *  @function: SyncPushDataHandler
   *  @descript: when recv the sync data,  sync_service will invoke the callback
   *  @param: data present sync data
   *  @param: topic present listen topic
   *  @param: biz_type present sync channel
   *  @param: obj_type present channel sub channel
   *  @return: true handler success, false handler failure
   */
  typedef std::function<bool (
      const std::string& data,
      const std::string& topic,
      int32_t biz_type,
      int32_t obj_type)> SyncPushDataHandler;

  virtual ~SyncInterface() {}
  
  /**
   *  @function: RegisterPushDataObserver
   *  @descript: register sync push listener
   *  @param: module_name present which module do listener
   *  @param: topic present sync serivce subscribe topic
   *  @param: handler present data push handler
   */
  virtual bool RegisterPushDataObserver(
      const std::string& module_name,
      const std::string& topic,
      SyncPushDataHandler handler) {
    return false;
  }
  
  /**
   *  @function: UnRegisterPushDataObserver
   *  @descript: unregister sync push listener
   *  @param: module_name present which module do listener
   *  @param: topic present sync serivce has subscribe topic
   */
  virtual bool UnRegisterPushDataObserver(
      const std::string& module_name,
      const std::string& topic) {
    return false;
  }
};
typedef std::shared_ptr<SyncInterface> SyncInterfacePtr;


}
}

#endif /* GAEA_INTERFACE_SYNC_SERVICE_H_ */
