//
//  trace_commit_interface.hpp
//  GaeaInterface
//
//  Created by Herb on 2019/6/28.
//  Copyright © 2019 DingTalk. All rights reserved.
//

#ifndef GAEA_SERVICE_TRACE_INTERFACE_H_
#define GAEA_SERVICE_TRACE_INTERFACE_H_

#include <stdio.h>
#include <string>
#include <memory>
#include <map>
#include "gaea/interface/base_interface.h"
#include "gaea/base/string_util.h"

namespace gaea {
namespace service {

class TraceInterface : public BaseInterface {
 public:
  TraceInterface() {}
  virtual ~TraceInterface() {}
  
  /**
   * @function Register
   * @brief 对外注册打点的主要信息，包含module、monitor_point、维度、指标等相关的key
   * @param module 模块名
   * @param monitor_point 监控点
   * @param dimension_keys 需要注册的维度的键值列表
   * @param measure_keys 需要注册的指标的键值列表
   * 在CommitStat之前需要将打点的key值通过该方法进行注册，否则打点结果无法统计到打点平台。对同一组打点内容只需要注册一次。
   */
  virtual void Register(const std::string& module,
                        const std::string& monitor_point,
                        const std::vector<std::string>& dimension_keys,
                        const std::vector<std::string>& measure_keys) {}
  
  virtual void CommitSuccess(const std::string& module,
                             const std::string& monitor_point,
                             const std::map<std::string, std::string>& extensions) {}
  
  virtual void CommitFail(const std::string& module,
                          const std::string& monitor_point,
                          int error_code,
                          const std::string& error_msg,
                          const std::map<std::string, std::string>& extensions) {}
  
  virtual void CommitCount(const std::string& module,
                           const std::string& monitor_point,
                           double count,
                           const std::map<std::string, std::string>& extensions) {}
  
  virtual void CommitStat(
      const std::string& module,
      const std::string& monitor_point,
      const std::map<std::string, std::string>& dimension_values,
      const std::map<std::string, double>& measure_values) {}
};
typedef std::shared_ptr<TraceInterface> TraceInterfacePtr;

} // end of namespace service
} // end of namespace gaea

#endif /* GAEA_SERVICE_TRACE_INTERFACE_H_ */
