//
//  file_transaction_manager_delegate.cpp
//  gaea_lwp
//
//  Created by Herb on 2020/1/2.
//  Copyright © 2020 DingTalk. All rights reserved.
//

#ifndef GAEA_LWP_FILE_TRANSACTION_MANAGER_DELEGATE_H_
#define GAEA_LWP_FILE_TRANSACTION_MANAGER_DELEGATE_H_

#include "gaea/lwp/gaea_define.h"

namespace gaea {
namespace base {
  class ErrorResult;
}
};

GAEA_LWP_NAMESPACE_BEGIN

class BaseTransaction;
typedef std::shared_ptr<BaseTransaction> BaseTransactionPtr;
typedef std::weak_ptr<BaseTransaction> BaseTransactionWeakPtr;

class CommonTransactionManagerDelegate {
 public:
  virtual void OnPending(BaseTransactionPtr transaction) {}
  virtual void OnStart(BaseTransactionPtr transaction) = 0;
  virtual void OnStartTransactionExpiredTimer(BaseTransactionPtr transaction) = 0;
  virtual void OnRemoveTimer(BaseTransactionPtr transaction) = 0;
  virtual void OnPreProcess(BaseTransactionPtr transaction) = 0;
  virtual void OnProcess(BaseTransactionPtr transaction) = 0;
  virtual void OnComplete(BaseTransactionPtr transaction) = 0;
  virtual bool OnCheckIfReady(BaseTransactionPtr transaction, gaea::base::ErrorResult* result) = 0;
  virtual void OnTerminated(BaseTransactionPtr transaction) = 0;
};
typedef std::shared_ptr<CommonTransactionManagerDelegate> CommonTransactionManagerDelegatePtr;

GAEA_LWP_NAMESPACE_END

#endif /* GAEA_LWP_FILE_TRANSACTION_MANAGER_DELEGATE_H_ */
