//
//  error_code_helper.h
//  GaeaLwp
//
//  Created by guodi.ggd on 2019/6/21.
//  Copyright © 2019 DingTalk. All rights reserved.
//

#ifndef error_code_helper_h
#define error_code_helper_h

#include <stdio.h>
#include <string>
#include <map>
#include "gaea/lwp/gaea_define.h"

#define TO_STR_CODE(v) gaea::lwp::ErrorCodeHelper::Code(v)
#define TO_DEV_MSG(v) gaea::lwp::ErrorCodeHelper::DevelopMessage(v)

GAEA_LWP_NAMESPACE_BEGIN
    
extern const char * kErrorSysMemoryMsg;
extern const char * kErrorUploadFailedMsg;
extern const char * kErrorDownloadFailedMsg;
extern const char * kErrorFileTaskCancelMsg;
extern const char * kErrorUserLogoutMsg;
extern const char * kErrorFileTransManagerExceptionMsg;

  enum ErrorCode {
    kErrorOK                  = 0,
    kErrorInvalidParam        = -1,
    kErrorInvalidOperation    = -2,
    kErrorTimeout             = -3,
    kErrorNetworkBroken       = -4,
    kErrorNoAuthToken         = -5,
    kErrorNotConnected        = -6,
    kErrorIsAuthing           = -7,
    kErrorIsAuthed            = -8,
    kErrorTokenIsEmpty        = -9,
    kErrorUnknown             = -10,
    kErrorUnpackException     = -11,
    kErrorCodeReasonNotSet    = -12,
    kErrorLogout              = -13,
    kErrorSendError           = -14,
    kErrorNetworkUnavailable  = -15,
    KErrorNetworkTimeout      = -16,
  };
  

  class ErrorCodeHelper {
   public:
    ErrorCodeHelper() {}
    virtual ~ErrorCodeHelper() {}
    static std::string Code(const ErrorCode& err_type_code);
    static const std::string DevelopMessage(const ErrorCode& err_type_code);
   private:
//    static void BuildCodeMsgMap();
  };
GAEA_LWP_NAMESPACE_END
#endif /* error_code_helper_h */
